/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.mailbox;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.ai.IUnitAI;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.IMailBox;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.IMessage;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MailBox
implements IMailBox {
    private Map<Class<? extends IUnitAI>, List<IUnitAI>> listenerAIListByClass = new Hashtable<Class<? extends IUnitAI>, List<IUnitAI>>();
    private Map<WorldObjectId, IUnitAI> listenerAIListById = new Hashtable<WorldObjectId, IUnitAI>();

    @Override
    public void mail(Class<? extends IUnitAI> targetAIClass, IMessage message) {
        if (targetAIClass == null) {
            return;
        }
        List<IUnitAI> ais = this.listenerAIListByClass.get(targetAIClass);
        if (ais == null) {
            return;
        }
        for (IUnitAI ai : ais) {
            ai.receiveMessage(message);
        }
    }

    @Override
    public void mail(WorldObjectId targetId, IMessage message) {
        if (targetId == null) {
            return;
        }
        IUnitAI ai = this.listenerAIListById.get(targetId);
        if (ai == null) {
            return;
        }
        ai.receiveMessage(message);
    }

    @Override
    public void mail(IUnitAI ai, IMessage message) {
        if (ai != null) {
            ai.receiveMessage(message);
        }
    }

    @Override
    public void registerAI(IUnitAI ai) {
        if (ai == null) {
            return;
        }
        List<IUnitAI> ais = this.listenerAIListByClass.get(ai.getClass());
        if (ais == null) {
            ais = new LinkedList<IUnitAI>();
            this.listenerAIListByClass.put(ai.getClass(), ais);
        } else if (ais.contains(ai)) {
            return;
        }
        ais.add(ai);
        this.listenerAIListById.put(ai.getId(), ai);
    }

    @Override
    public void unregisterAI(IUnitAI ai) {
        if (ai == null) {
            return;
        }
        List<IUnitAI> ais = this.listenerAIListByClass.get(ai.getClass());
        if (ais == null) {
            return;
        }
        if (ais.contains(ai)) {
            ais.remove(ai);
        }
        this.listenerAIListById.remove(ai.getId());
    }
}

