/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.agent.impl;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentController;
import cz.cuni.amis.pogamut.defcon.agent.impl.ILogicUpdateListener;
import cz.cuni.amis.pogamut.defcon.agent.module.logic.DefConAgentLogic;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.IMailBox;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.MailBox;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.GameRunningChanged;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.IFlagChecker;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingsManager;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.FleetsManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Logger;

@AgentScoped
public class DefConAgentLogicController<AGENT extends DefConAgent>
extends DefConAgentController<AGENT>
implements IDefConAgentLogicController<AGENT, LogicModule<AGENT>> {
    protected DefConAgentLogic<AGENT> logicModule;
    private AnnotationListenerRegistrator listenerRegistrator;
    private Method logicMethod;
    private Method gameLogic;
    private Method preGameLogic;
    private Method firstGameLogic;
    protected DefConWorldView worldview;
    protected GameInfo gameInfo;
    private final Random random = new Random();
    private final IMailBox mailBox = new MailBox();
    private final LinkedList<ILogicUpdateListener> logicUpdateListeners = new LinkedList();
    protected FleetsManager fleetsManager;
    protected BuildingsManager buildingsManager;
    protected IFlagChecker flagChecker;
    public IWorldEventListener<GameRunningChanged> gameStartedListener = new IWorldEventListener<GameRunningChanged>(){

        public void notify(GameRunningChanged event) {
            if (event.getRunning().booleanValue()) {
                try {
                    DefConAgentLogicController.this.logicMethod = DefConAgentLogicController.this.firstGameLogic;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    DefConAgentLogicController.this.agent.stop();
                }
            }
        }
    };

    public DefConAgentLogicController() {
        try {
            this.logicMethod = this.preGameLogic = this.getClass().getMethod("preGameLogic", new Class[0]);
            this.gameLogic = this.getClass().getMethod("gameLogicWorker", new Class[0]);
            this.firstGameLogic = DefConAgentLogicController.class.getDeclaredMethod("firstGameLogicWorker", new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            this.agent.stop();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            this.agent.stop();
        }
    }

    @Override
    public void initializeController(AGENT agent) {
        super.initializeController(agent);
        this.logicModule = new DefConAgentLogic<AGENT>(agent, this);
        this.worldview = ((DefConAgent)agent).getWorldView();
        this.gameInfo = this.worldview.getGameInfo();
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.worldview, (Logger)this.getLog());
        this.worldview.addEventListener(GameRunningChanged.class, this.gameStartedListener);
        this.listenerRegistrator.addListeners();
    }

    public long getLogicInitializeTime() {
        return 120000L;
    }

    public long getLogicShutdownTime() {
        return 120000L;
    }

    public void beforeFirstLogic() {
    }

    public void logic() {
        try {
            this.worldview.updateProducer();
            this.logicMethod.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.agent.stop();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.agent.stop();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.agent.stop();
        }
    }

    public void preGameLogic() {
    }

    public void firstGameLogic() {
        this.gameLogic();
    }

    private final void firstGameLogicWorker() {
        this.logicMethod = this.gameLogic;
        this.firstGameLogic();
    }

    public void gameLogic() {
    }

    public final void gameLogicWorker() {
        for (ILogicUpdateListener listener : this.logicUpdateListeners) {
            listener.update();
        }
        this.gameLogic();
    }

    public void logicInitialize(LogicModule<AGENT> logicModule) {
        this.logicModule = (DefConAgentLogic)logicModule;
    }

    public void logicShutdown() {
    }

    public void addGameLogicListener(ILogicUpdateListener updateListener) {
        if (updateListener != null) {
            this.logicUpdateListeners.add(updateListener);
        }
    }

    public void unregisterUpdates(ILogicUpdateListener updateListener) {
        if (this.logicUpdateListeners.contains(updateListener)) {
            this.logicUpdateListeners.remove(updateListener);
        }
    }

    public final Random getRandom() {
        return this.random;
    }

    public final IMailBox getMailBox() {
        return this.mailBox;
    }

    public IFlagChecker getFlagChecker() {
        return this.flagChecker;
    }

    public final FleetsManager getFleetsManager() {
        return this.fleetsManager;
    }

    public final BuildingsManager getBuildingsManager() {
        return this.buildingsManager;
    }
}

