package javabot;

import java.lang.reflect.Method;

/**
 * Caches all methods inside JBot for an easier retrieval for reflection.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class JBotMethodsRepository {

	private static Method getDefcon;
	private static Method getGameTime;
	private static Method getGameTick;
	private static Method getGameSpeed;
	private static Method getVictoryTimer;
	private static Method isVictoryTimerActive;
	private static Method getOptionValue;
	private static Method getCityIds;
	private static Method getCityPopulation;
	private static Method getRemainingPopulation;
	private static Method isValidTerritory;
	private static Method isBorder;
	private static Method getTerritoryId;
	private static Method getOwnTeamId;
	private static Method getTeamIds;
	private static Method getTeamTerritoriesCount;
	private static Method getTeamTerritories;
	private static Method getAllianceId;
	private static Method getDesiredGameSpeed;
	private static Method getEnemyKills;
	private static Method getFriendlyDeaths;
	private static Method getCollateralDamage;
	private static Method getTeamName;
	private static Method isSharingRadar;
	private static Method isCeaseFire;
	private static Method requestAlliance;
	private static Method requestCeaseFire;
	private static Method requestShareRadar;
	private static Method requestGameSpeed;
	private static Method getAllUnits;
	private static Method getOwnUnits;
	private static Method getTeamUnits;
	private static Method getAllUnitData;
	private static Method getType;
	private static Method getTeamId;
	private static Method getOwnFleets;
	private static Method getFleets;
	private static Method getFleetMembers;
	private static Method getFleetId;
	private static Method getCurrentState;
	private static Method getStateCount;
	private static Method getStateTimer;
	private static Method getActionQueue;
	private static Method getCurrentTargetId;
	private static Method getMovementTargetLocation;
	private static Method getNukeSupply;
	private static Method getBomberNukeTarget;
	private static Method isRetaliating;
	private static Method isVisible;
	private static Method setState;
	private static Method setMovementTarget;
	private static Method setActionTarget;
	private static Method setLandingTarget;
	private static Method getLongitude;
	private static Method getLatitude;
	private static Method getVelocity;
	private static Method getRange;
	private static Method getRemainingUnits;
	private static Method isValidPlacementLocation;
	private static Method getFleetMemberOffset;
	private static Method placeStructure;
	private static Method placeFleet;
	private static Method getUnitCredits;
	private static Method getUnitValue;
	private static Method sendVote;
	private static Method sendChatMessage;
	private static Method getDistance;
	private static Method getSailDistance;
	private static Method debugLog0;
	private static Method debugLog1;
	private static Method debugLog2;
	private static Method debugLog3;
	private static Method debugLog4;
	private static Method debugIsReplayingGame;
	private static Method whiteboardDraw;
	private static Method whiteboardClear;
	private static Method getSuccessfulCommands;
	private static Method writeToConsole;

	static {
		try {
			getDefcon = JBot.class.getDeclaredMethod("GetDefcon");
			getGameTime = JBot.class.getDeclaredMethod("GetGameTime");
			getGameTick = JBot.class.getDeclaredMethod("GetGameTick");
			getGameSpeed = JBot.class.getDeclaredMethod("GetGameSpeed");
			getVictoryTimer = JBot.class.getDeclaredMethod("GetVictoryTimer");
			isVictoryTimerActive = JBot.class
					.getDeclaredMethod("IsVictoryTimerActive");
			getOptionValue = JBot.class.getDeclaredMethod(
					"GetOptionValue",
					String.class);
			getCityIds = JBot.class.getDeclaredMethod("GetCityIds");
			getCityPopulation = JBot.class
					.getDeclaredMethod("GetCityPopulation", int.class);
			getRemainingPopulation = JBot.class.getDeclaredMethod(
					"GetRemainingPopulation",
					int.class);
			isValidTerritory = JBot.class.getDeclaredMethod("IsValidTerritory",
					int.class, float.class, float.class, boolean.class);
			isBorder = JBot.class.getDeclaredMethod(
					"IsBorder",
					float.class,
					float.class);
			getTerritoryId = JBot.class.getDeclaredMethod("GetTerritoryId",
					float.class,
					float.class);
			getOwnTeamId = JBot.class.getDeclaredMethod("GetOwnTeamId");
			getTeamIds = JBot.class.getDeclaredMethod("GetTeamIds");
			getTeamTerritoriesCount = JBot.class.getDeclaredMethod(
					"GetTeamTerritoriesCount",
					int.class);
			getTeamTerritories = JBot.class.getDeclaredMethod(
					"GetTeamTerritories",
					int.class);
			getAllianceId = JBot.class.getDeclaredMethod("GetAllianceId",
					int.class);
			getDesiredGameSpeed = JBot.class.getDeclaredMethod(
					"GetDesiredGameSpeed",
					int.class);
			getEnemyKills = JBot.class.getDeclaredMethod(
					"GetEnemyKills",
					int.class);
			getFriendlyDeaths = JBot.class.getDeclaredMethod(
					"GetFriendlyDeaths",
					int.class);
			getCollateralDamage = JBot.class.getDeclaredMethod(
					"GetCollateralDamage",
					int.class);
			getTeamName = JBot.class.getDeclaredMethod("GetTeamName",
					int.class);
			isSharingRadar = JBot.class.getDeclaredMethod("IsSharingRadar",
					int.class,
					int.class);
			isCeaseFire = JBot.class.getDeclaredMethod("IsCeaseFire",
					int.class,
					int.class);
			requestAlliance = JBot.class.getDeclaredMethod("RequestAlliance",
					int.class);
			requestCeaseFire = JBot.class.getDeclaredMethod("RequestCeaseFire",
					int.class);
			requestShareRadar = JBot.class.getDeclaredMethod(
					"RequestShareRadar",
					int.class);
			requestGameSpeed = JBot.class.getDeclaredMethod("RequestGameSpeed",
					int.class);
			getAllUnits = JBot.class.getDeclaredMethod("GetAllUnits");
			getOwnUnits = JBot.class.getDeclaredMethod("GetOwnUnits");
			getTeamUnits = JBot.class.getDeclaredMethod(
					"GetTeamUnits",
					int.class);
			getAllUnitData = JBot.class.getDeclaredMethod("GetAllUnitData");
			getType = JBot.class.getDeclaredMethod("GetType", int.class);
			getTeamId = JBot.class
					.getDeclaredMethod("GetTeamId", int.class);
			getOwnFleets = JBot.class.getDeclaredMethod("GetOwnFleets");
			getFleets = JBot.class.getDeclaredMethod("GetFleets",
					int.class);
			getFleetMembers = JBot.class.getDeclaredMethod("GetFleetMembers",
					int.class);
			getFleetId = JBot.class.getDeclaredMethod("GetFleetId",
					int.class);
			getCurrentState = JBot.class.getDeclaredMethod("GetCurrentState",
					int.class);
			getStateCount = JBot.class.getDeclaredMethod("GetStateCount",
					int.class,
					int.class);
			getStateTimer = JBot.class.getDeclaredMethod("GetStateTimer",
					int.class);
			getActionQueue = JBot.class.getDeclaredMethod("GetActionQueue",
					int.class);
			getCurrentTargetId = JBot.class.getDeclaredMethod(
					"GetCurrentTargetId",
					int.class);
			getMovementTargetLocation = JBot.class.getDeclaredMethod(
					"GetMovementTargetLocation",
					int.class);
			getNukeSupply = JBot.class.getDeclaredMethod("GetNukeSupply",
					int.class);
			getBomberNukeTarget = JBot.class.getDeclaredMethod(
					"GetBomberNukeTarget",
					int.class);
			isRetaliating = JBot.class.getDeclaredMethod("IsRetaliating",
					int.class);
			isVisible = JBot.class.getDeclaredMethod("IsVisible",
					int.class, int.class);
			setState = JBot.class.getDeclaredMethod("SetState",
					int.class, int.class);
			setMovementTarget = JBot.class.getDeclaredMethod(
					"SetMovementTarget",
					int.class,
					float.class,
					float.class);
			setActionTarget = JBot.class.getDeclaredMethod("SetActionTarget",
					int.class,
					int.class,
					float.class,
					float.class);
			setLandingTarget = JBot.class.getDeclaredMethod("SetLandingTarget",
					int.class,
					int.class);
			getLongitude = JBot.class.getDeclaredMethod("GetLongitude",
					int.class);
			getLatitude = JBot.class.getDeclaredMethod("GetLatitude",
					int.class);
			getVelocity = JBot.class.getDeclaredMethod("GetVelocity",
					int.class);
			getRange = JBot.class.getDeclaredMethod("GetRange",
					int.class);
			getRemainingUnits = JBot.class.getDeclaredMethod(
					"GetRemainingUnits",
					int.class);

			isValidPlacementLocation = JBot.class.getDeclaredMethod(
					"IsValidPlacementLocation",
					float.class,
					float.class,
					int.class);

			/*
			 * isValidPlacementLocation = GameInfo.class.getDeclaredMethod(
			 * "isValidPlacementLocationWorker", float.class, float.class,
			 * UnitType.class);
			 */
			getFleetMemberOffset = JBot.class.getDeclaredMethod(
					"GetFleetMemberOffset",
					int.class,
					int.class);
			placeStructure = JBot.class.getDeclaredMethod("PlaceStructure",
					int.class,
					float.class,
					float.class);
			placeFleet = JBot.class.getDeclaredMethod("PlaceFleet",
					float.class,
					float.class,
					int[].class);
			getUnitCredits = JBot.class.getDeclaredMethod("GetUnitCredits");
			getUnitValue = JBot.class.getDeclaredMethod("GetUnitValue",
					int.class);
			sendVote = JBot.class.getDeclaredMethod(
					"SendVote",
					int.class,
					int.class);
			sendChatMessage = JBot.class.getDeclaredMethod("SendChatMessage",
					String.class,
					int.class);
			getDistance = JBot.class.getDeclaredMethod("GetDistance",
					float.class,
					float.class,
					float.class,
					float.class);
			getSailDistance = JBot.class.getDeclaredMethod("GetSailDistance",
					float.class,
					float.class,
					float.class,
					float.class);
			debugLog0 = JBot.class.getDeclaredMethod("DebugLog", String.class);
			debugLog1 = JBot.class.getDeclaredMethod("DebugLog", String.class,
					int.class);
			debugLog2 = JBot.class.getDeclaredMethod(
					"DebugLog",
					String.class,
					int.class,
					String.class);
			debugLog3 = JBot.class.getDeclaredMethod("DebugLog",
					String.class,
					int.class,
					String.class,
					int.class,
					int.class,
					int.class);
			debugLog4 = JBot.class.getDeclaredMethod("DebugLog",
					String.class,
					int.class,
					String.class,
					int.class,
					int.class,
					int.class,
					int.class);
			debugIsReplayingGame = JBot.class
					.getDeclaredMethod("DebugIsReplayingGame");
			whiteboardDraw = JBot.class.getDeclaredMethod("WhiteboardDraw",
					float.class,
					float.class,
					float.class,
					float.class);
			whiteboardClear = JBot.class.getDeclaredMethod("WhiteboardClear");
			getSuccessfulCommands = JBot.class
					.getDeclaredMethod("GetSuccessfulCommands");
			writeToConsole = JBot.class.getDeclaredMethod("WriteToConsole",
					String.class);
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static final Method GetDefcon() {
		return getDefcon;
	}

	public static final Method GetGameTime() {
		return getGameTime;
	}

	public static final Method GetGameTick() {
		return getGameTick;
	}

	public static final Method GetGameSpeed() {
		return getGameSpeed;
	}

	public static final Method GetVictoryTimer() {
		return getVictoryTimer;
	}

	public static final Method IsVictoryTimerActive() {
		return isVictoryTimerActive;
	}

	public static final Method GetOptionValue() {
		return getOptionValue;
	}

	public static final Method GetCityIds() {
		return getCityIds;
	}

	public static final Method GetCityPopulation() {
		return getCityPopulation;
	}

	public static final Method GetRemainingPopulation() {
		return getRemainingPopulation;
	}

	public static final Method IsValidTerritory() {
		return isValidTerritory;
	}

	public static final Method IsBorder() {
		return isBorder;
	}

	public static final Method GetTerritoryId() {
		return getTerritoryId;
	}

	public static final Method GetOwnTeamId() {
		return getOwnTeamId;
	}

	public static final Method GetTeamIds() {
		return getTeamIds;
	}

	public static final Method GetTeamTerritoriesCount() {
		return getTeamTerritoriesCount;
	}

	public static final Method GetTeamTerritories() {
		return getTeamTerritories;
	}

	public static final Method GetAllianceId() {
		return getAllianceId;
	}

	public static final Method GetDesiredGameSpeed() {
		return getDesiredGameSpeed;
	}

	public static final Method GetEnemyKills() {
		return getEnemyKills;
	}

	public static final Method GetFriendlyDeaths() {
		return getFriendlyDeaths;
	}

	public static final Method GetCollateralDamage() {
		return getCollateralDamage;
	}

	public static final Method GetTeamName() {
		return getTeamName;
	}

	public static final Method IsSharingRadar() {
		return isSharingRadar;
	}

	public static final Method IsCeaseFire() {
		return isCeaseFire;
	}

	public static final Method RequestAlliance() {
		return requestAlliance;
	}

	public static final Method RequestCeaseFire() {
		return requestCeaseFire;
	}

	public static final Method RequestShareRadar() {
		return requestShareRadar;
	}

	public static final Method RequestGameSpeed() {
		return requestGameSpeed;
	}

	public static final Method GetAllUnits() {
		return getAllUnits;
	}

	public static final Method GetOwnUnits() {
		return getOwnUnits;
	}

	public static final Method GetTeamUnits() {
		return getTeamUnits;
	}

	public static final Method GetAllUnitData() {
		return getAllUnitData;
	}

	public static final Method GetType() {
		return getType;
	}

	public static final Method GetTeamId() {
		return getTeamId;
	}

	public static final Method GetOwnFleets() {
		return getOwnFleets;
	}

	public static final Method GetFleets() {
		return getFleets;
	}

	public static final Method GetFleetMembers() {
		return getFleetMembers;
	}

	public static final Method GetFleetId() {
		return getFleetId;
	}

	public static final Method GetCurrentState() {
		return getCurrentState;
	}

	public static final Method GetStateCount() {
		return getStateCount;
	}

	public static final Method GetStateTimer() {
		return getStateTimer;
	}

	public static final Method GetActionQueue() {
		return getActionQueue;
	}

	public static final Method GetCurrentTargetId() {
		return getCurrentTargetId;
	}

	public static final Method GetMovementTargetLocation() {
		return getMovementTargetLocation;
	}

	public static final Method GetNukeSupply() {
		return getNukeSupply;
	}

	public static final Method GetBomberNukeTarget() {
		return getBomberNukeTarget;
	}

	public static final Method IsRetaliating() {
		return isRetaliating;
	}

	public static final Method IsVisible() {
		return isVisible;
	}

	public static final Method SetState() {
		return setState;
	}

	public static final Method SetMovementTarget() {
		return setMovementTarget;
	}

	public static final Method SetActionTarget() {
		return setActionTarget;
	}

	public static final Method SetLandingTarget() {
		return setLandingTarget;
	}

	public static final Method GetLongitude() {
		return getLongitude;
	}

	public static final Method GetLatitude() {
		return getLatitude;
	}

	public static final Method GetVelocity() {
		return getVelocity;
	}

	public static final Method GetRange() {
		return getRange;
	}

	public static final Method GetRemainingUnits() {
		return getRemainingUnits;
	}

	public static final Method IsValidPlacementLocation() {
		return isValidPlacementLocation;
	}

	public static final Method GetFleetMemberOffset() {
		return getFleetMemberOffset;
	}

	public static final Method PlaceStructure() {
		return placeStructure;
	}

	public static final Method PlaceFleet() {
		return placeFleet;
	}

	public static final Method GetUnitCredits() {
		return getUnitCredits;
	}

	public static final Method GetUnitValue() {
		return getUnitValue;
	}

	public static final Method SendVote() {
		return sendVote;
	}

	public static final Method SendChatMessage() {
		return sendChatMessage;
	}

	public static final Method GetDistance() {
		return getDistance;
	}

	public static final Method GetSailDistance() {
		return getSailDistance;
	}

	public static final Method DebugLog0() {
		return debugLog0;
	}

	public static final Method DebugLog1() {
		return debugLog1;
	}

	public static final Method DebugLog2() {
		return debugLog2;
	}

	public static final Method DebugLog3() {
		return debugLog3;
	}

	public static final Method DebugLog4() {
		return debugLog4;
	}

	public static final Method DebugIsReplayingGame() {
		return debugIsReplayingGame;
	}

	public static final Method WhiteboardDraw() {
		return whiteboardDraw;
	}

	public static final Method WhiteboardClear() {
		return whiteboardClear;
	}

	public static final Method GetSuccessfulCommands() {
		return getSuccessfulCommands;
	}

	public static final Method WriteToConsole() {
		return writeToConsole;
	}
}
