package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Radars.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum RadarState implements IState {
	
	ACTIVE(JBot.STATE_RADARACTIVE);
	
	private static Map<Integer, RadarState> states = new HashMap<Integer, RadarState>();
	
	public static RadarState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (RadarState state : RadarState.values()) {
			states.put(state.getStateId(), state);
		}
	}
	
	public final int id;
	
	private RadarState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
