package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * One of the game options. Might be accessed through {@link GameInfo#GetOptionValue()}
 * and {@link GameOption}.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum CityPopulations {
	
	DEFAULT(0),
	EQUALISED(1),
	RANDOM(2),
	TOTALLY_RANDOM(3);
	
	private static Map<Integer, CityPopulations> enums = new HashMap<Integer, CityPopulations>();
	
	public static CityPopulations getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (CityPopulations item : CityPopulations.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private CityPopulations(int id) {
		this.id = id;
	}

}
