package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.utils.Pair;

/**
 * Manages collected quadtrees.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class QuadTreesManager {

	private final SortedMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>> enemyQuadTrees =
			new TreeMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>>();
	private final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownQuadTrees =
			new TreeMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>();

	public QuadTreesManager(
			SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> ownTerritories,
			SortedMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemyTerritories,
			DefConWorldView worldview) {
		this(ownTerritories, enemyTerritories, worldview, null);
	}

	public QuadTreesManager(
			SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> ownTerritories,
			SortedMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemyTerritories,
			DefConWorldView worldview, Logger log) {

		for (Entry<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> territory : ownTerritories
				.entrySet()) {

			Pair<List<QuadTree>, List<QuadTree>> qTreesPair = new Pair<List<QuadTree>, List<QuadTree>>();

			ownQuadTrees.put(territory.getKey(), qTreesPair);

			// log.info("Trees: " + ownTerritories.keySet().toString());

			ArrayList<QuadTree> qTreesList = new ArrayList<QuadTree>();
			qTreesPair.first = qTreesList;

			for (List<DefConLocation> sea : territory.getValue().first) {
				QuadTree tree = new QuadTree(sea);

				QuadTreeLabeler.label(tree, new
						UnitPlacementQuadTreeLabellingMethod(worldview,
								log));

				qTreesList.add(tree);
			}

			qTreesList = new ArrayList<QuadTree>();
			qTreesPair.second = qTreesList;

			for (List<DefConLocation> land : territory.getValue().second) {
				QuadTree tree = new QuadTree(land);

				QuadTreeLabeler.label(tree, new
						BuildingPlacementQuadTreeLabellingMethod(worldview,
								log));

				qTreesList.add(tree);
			}
		}

		// log.info("EnemyTeamIds: "
		// + enemyTerritories.keySet().toString());

		for (Entry<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemy : enemyTerritories
				.entrySet()) {

			SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemy_territories =
					new TreeMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>();

			enemyQuadTrees.put(enemy.getKey(), enemy_territories);

			for (Entry<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> territory : enemy
					.getValue().entrySet()) {

				Pair<List<QuadTree>, List<QuadTree>> qTreesPair = new Pair<List<QuadTree>, List<QuadTree>>();

				enemy_territories.put(territory.getKey(), qTreesPair);

				// log.info("Trees: " + enemy_territories.keySet().toString());

				ArrayList<QuadTree> qTreesList = new ArrayList<QuadTree>();
				qTreesPair.first = qTreesList;

				for (List<DefConLocation> sea : territory.getValue().first) {
					QuadTree tree = new QuadTree(sea);

					qTreesList.add(tree);
				}

				qTreesList = new ArrayList<QuadTree>();
				qTreesPair.second = qTreesList;

				for (List<DefConLocation> land : territory.getValue().second) {
					QuadTree tree = new QuadTree(land);

					qTreesList.add(tree);
				}
			}
		}
	}

	public final SortedMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>> getEnemyQuadTrees() {
		return Collections.unmodifiableSortedMap(enemyQuadTrees);
	}

	public final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> getEnemyQuadTrees(
			int enemyId) {
		return Collections.unmodifiableSortedMap(enemyQuadTrees.get(enemyId));
	}

	public final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> getOwnQuadTrees() {
		return Collections.unmodifiableSortedMap(ownQuadTrees);
	}
}
