package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/**
 * Allows user to iterate over
 * {@link cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree}s, in a BFS
 * manner.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class QuadTreeBFSIterator implements Iterator<QuadTreeNode> {

	private QuadTree tree;
	private QuadTreeNode node = null;
	private QuadTreeNode root = null;
	private boolean finished = false;
	private final LinkedList<QuadTreeNode> branching = new LinkedList<QuadTreeNode>();


	public QuadTreeBFSIterator(QuadTree tree) {
		if (tree == null)
			throw new IllegalArgumentException("Tree cannot be null");

		this.tree = tree;
		this.root = tree.getRoot();
		branching.addLast(root);
	}

	@Override
	public boolean hasNext() {
		return !branching.isEmpty();
	}

	@Override
	public QuadTreeNode next() {
		if (!hasNext())
			throw new NoSuchElementException();

		QuadTreeNode node = branching.pop();

		if (node.getNodes() != null) {
			for (QuadTreeNode child : node.getNodes()) {
				branching.addLast(child);
			}
		}

		return node;
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException(
				"QuadTreeIterator does not support remove() method.");
	}

}
