package cz.cuni.amis.pogamut.defcon.utils.closestpoints;

import java.util.List;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsLookUp.ClosestPoints;

/**
 * Collects the reasonably good spawn points for fleet spawning and simplifies
 * access to them.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class ClosestPointsManager {

	/**
	 * First index is enemy, second his territoryId, third own territoryId.
	 */
	private SortedMap<Integer, SortedMap<Integer, List<ClosestPoints>>> closestPoints;

	private Logger log;


	public ClosestPointsManager(
			SortedMap<Integer, SortedMap<Integer, List<ClosestPoints>>> closestPoints) {
		this(closestPoints, null);
	}

	public ClosestPointsManager(
			SortedMap<Integer, SortedMap<Integer, List<ClosestPoints>>> closestPointsToEnemyTerritories,
			Logger log) {
		this.closestPoints = closestPointsToEnemyTerritories;
		this.log = log;
	}

	public final SortedMap<Integer, SortedMap<Integer, List<ClosestPoints>>> getClosestPoints() {
		return closestPoints;
	}

	public List<ClosestPoints> getClosestForSpecificTerritories(
			int enemyTerritoryId,
			int ownTerritoryId) {

		return closestPoints.get(enemyTerritoryId).get(ownTerritoryId);
	}

	public SortedMap<Integer, List<ClosestPoints>> getClosestForEnemyTerritory(
			int enemyTerritoryId) {

		return closestPoints.get(enemyTerritoryId);
	}
}
