package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Nukes.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum NukeState implements IState {

	ON_TARGET(JBot.STATE_NUKEONTARGET),
	DISARM(JBot.STATE_NUKEDISARM);
	
	private static Map<Integer, NukeState> states = new HashMap<Integer, NukeState>();
	
	public static NukeState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (NukeState state : NukeState.values()) {
			states.put(state.getStateId(), state);
		}
	}

	
	public final int id;
	
	private NukeState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}
    
	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}
}
