package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Carriers.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum CarrierState implements IState {
	
	FIGHTER_LAUNCH(JBot.STATE_CARRIERFIGHTERLAUNCH),
	BOMBER_LAUNCH(JBot.STATE_CARRIERBOMBERLAUNCH),
	ANTISUB(JBot.STATE_CARRIERANTISUB);
	
	private static Map<Integer, CarrierState> states = new HashMap<Integer, CarrierState>();
	
	public static CarrierState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (CarrierState state : CarrierState.values()) {
			states.put(state.getStateId(), state);
		}
	}
	
	public final int id;
	
	private CarrierState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
