package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Battleships.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum BattleshipState implements IState {
	
	ATTACK(JBot.STATE_BATTLESHIPATTACK);

	private static Map<Integer, BattleshipState> states = new HashMap<Integer, BattleshipState>();
	
	public static BattleshipState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (BattleshipState state : BattleshipState.values()) {
			states.put(state.getStateId(), state);
		}
	}
	
	public final int id;
	
	private BattleshipState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
