package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * One of the game options. Might be accessed through {@link GameInfo#GetOptionValue()}
 * and {@link GameOption}.
 * Survivor mode is about loosing the least amount of people.
 * Genocide mode is about killing the greatest amount of people.
 * In default mode you receive 2 points for 1 kill and -1 point for 1 lost. 
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum ScoreMode {
	
	DEFAULT(0),
	SURVIVOR(1),
	GENOCIDE(2);
	
	private static Map<Integer, ScoreMode> enums = new HashMap<Integer, ScoreMode>();
	
	public static ScoreMode getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (ScoreMode item : ScoreMode.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private ScoreMode(int id) {
		this.id = id;
	}

}
