package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridIterator;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.BasicGrid.CellIndices;

/**
 * Iterator for the experimental grid.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class BasicGridIterator implements
		IGridIterator<SymmetricGridCell, SymmetricGridCellId> {

	private Location cellLocation;
	private CellIndices indices;
	private BasicGrid grid;

	private SymmetricGridCell cell;

	public BasicGridIterator(SymmetricGridCellId cellId, BasicGrid grid) {
		this.grid = grid;
		this.cell = grid.getCell(cellId);
		this.cellLocation = cellId.getLocation();
		this.indices = grid.getCellIndices(cellId);
	}
	
	@Override
	public SymmetricGridCell getCell() {
		return cell;
	}	

	@Override
	public SymmetricGridCell getBottomNeighbourCell() {
		return grid.getCell(indices.getX(), indices.getY() + grid.getGridStep());
	}

	@Override
	public SymmetricGridCell getLeftNeighbourCell() {
		return grid.getCell(indices.getX() - grid.getGridStep(), indices.getY());
	}

	@Override
	public SymmetricGridCell getRightNeighbourCell() {
		return grid.getCell(indices.getX() + grid.getGridStep(), indices.getY());
	}

	@Override
	public SymmetricGridCell getTopNeighbourCell() {
		return grid.getCell(indices.getX(), indices.getY() - grid.getGridStep());
	}

	@Override
	public SymmetricGridCell getBottomLeftNeighbourCell() {
		return grid.getCell(indices.getX() - grid.getGridStep(), indices.getY() + grid.getGridStep());
	}

	@Override
	public SymmetricGridCell getBottomRightNeighbourCell() {
		return grid.getCell(indices.getX() + grid.getGridStep(), indices.getY() + grid.getGridStep());
	}

	@Override
	public SymmetricGridCell getTopLeftNeighbourCell() {
		return grid.getCell(indices.getX() - grid.getGridStep(), indices.getY() - grid.getGridStep());
	}

	@Override
	public SymmetricGridCell getTopRightNeighbourCell() {
		return grid.getCell(indices.getX() + grid.getGridStep(), indices.getY() - grid.getGridStep());
	}

	@Override
	public List<SymmetricGridCell> getListOfNeighbouringCells() {
		LinkedList<SymmetricGridCell> cells = new LinkedList<SymmetricGridCell>();
		cells.add(getBottomNeighbourCell());
		cells.add(getLeftNeighbourCell());
		cells.add(getRightNeighbourCell());
		cells.add(getTopNeighbourCell());
		cells.add(getBottomLeftNeighbourCell());
		cells.add(getBottomRightNeighbourCell());
		cells.add(getTopLeftNeighbourCell());
		cells.add(getTopRightNeighbourCell());
		return cells;
	}

	private enum Direction {
		TOP(0, -1), TOP_RIGHT(1, -1), RIGHT(1, 0), BOTTOM_RIGHT(1, 1), BOTTOM(
				0, 1), BOTTOM_LEFT(-1, 1), LEFT(-1, 0), TOP_LEFT(-1, -1);

		private Direction(int x, int y) {
			this.x = x;
			this.y = y;
		}

		public final int x;
		public final int y;
	};

	@Override
	public SymmetricGridCell getNeighbourCellInDirection(Location direction) {
		Location tested_direction = new Location(1, 0);
		double maximal_dot = direction.dot(tested_direction);
		double current_dot;
		Direction dir = Direction.RIGHT;

		tested_direction.y = 1;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.BOTTOM_RIGHT;
			maximal_dot = current_dot;
		}

		tested_direction.x = 0;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.BOTTOM;
			maximal_dot = current_dot;
		}

		tested_direction.x = -1;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.BOTTOM_LEFT;
			maximal_dot = current_dot;
		}

		tested_direction.y = 0;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.BOTTOM_RIGHT;
			maximal_dot = current_dot;
		}

		tested_direction.y = -1;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.LEFT;
			maximal_dot = current_dot;
		}

		tested_direction.x = 0;
		if ((current_dot = direction.dot(tested_direction)) > maximal_dot) {
			dir = Direction.TOP;
			maximal_dot = current_dot;
		}

		switch (dir) {
		case TOP:
			return getTopNeighbourCell();
		case TOP_RIGHT:
			return getTopRightNeighbourCell();
		case RIGHT:
			return getRightNeighbourCell();
		case BOTTOM_RIGHT:
			return getBottomRightNeighbourCell();
		case BOTTOM:
			return getBottomNeighbourCell();
		case BOTTOM_LEFT:
			return getBottomLeftNeighbourCell();
		case LEFT:
			return getLeftNeighbourCell();
		case TOP_LEFT:
			return getTopLeftNeighbourCell();
		default:
			return null;
		}
	}

	@Override
	public LinkedList<SymmetricGridCellId> getCellsInRadiusOf(
			float radius) {

		LinkedList<SymmetricGridCellId> list = new LinkedList<SymmetricGridCellId>();
		int normed_radius = (int) Math.floor(radius/grid.getGridStep());
		int y_base = (int) cellLocation.getY();
		Location position = new Location((cellLocation.getX() - normed_radius),
				cellLocation.getY());		
		
		for (;
				position.x <= (int) (cellLocation.getX() + normed_radius);
				++position.x) {
			
			position.y = y_base;
			while (position.sub(cellLocation).getLength() < radius) {
				++position.y;
			}
			
			int y_diff = (int) (position.y - y_base - grid.getGridStep());			
			
			for (position.y = y_base - y_diff; position.y <= y_base + y_diff; ++position.y) {
				list.add(new SymmetricGridCellId(position));
			}
		}
		
		return list;
	}

	@Override
	public SymmetricGridCell moveToBottomLeftNeighbourCell() {
		cell = getBottomLeftNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToBottomNeighbourCell() {
		cell = getBottomNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToBottomRightNeighbourCell() {
		cell = getBottomRightNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToLeftNeighbourCell() {
		cell = getLeftNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToNeighbourCellInDirection(Location direction) {
		cell = moveToNeighbourCellInDirection(direction);
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToRightNeighbourCell() {
		cell = getRightNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToTopLeftNeighbourCell() {
		cell = getTopLeftNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToTopNeighbourCell() {
		cell = getTopNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}

	@Override
	public SymmetricGridCell moveToTopRightNeighbourCell() {
		cell = getTopRightNeighbourCell();
		cellLocation = cell.getCellId().getLocation();
		indices = grid.getCellIndices((SymmetricGridCellId) cell.getCellId());
		return cell;
	}
}
