package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * Iteator used for the experimental grid interface to traverse the map.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 * @param <GRID_CELL>
 * @param <GRID_CELL_ID>
 */
public interface IGridIterator<GRID_CELL extends IGridCell, GRID_CELL_ID extends IGridCellId> {
	
	public GRID_CELL getTopNeighbourCell();
	
	public GRID_CELL getRightNeighbourCell();
	
	public GRID_CELL getBottomNeighbourCell();
	
	public GRID_CELL getLeftNeighbourCell();
	
	public GRID_CELL getTopLeftNeighbourCell();
	
	public GRID_CELL getTopRightNeighbourCell();
	
	public GRID_CELL getBottomLeftNeighbourCell();
	
	public GRID_CELL getBottomRightNeighbourCell();
	
	public GRID_CELL getNeighbourCellInDirection(Location direction);	
	
	public GRID_CELL moveToTopNeighbourCell();
	
	public GRID_CELL moveToRightNeighbourCell();
	
	public GRID_CELL moveToBottomNeighbourCell();
	
	public GRID_CELL moveToLeftNeighbourCell();
	
	public GRID_CELL moveToTopLeftNeighbourCell();
	
	public GRID_CELL moveToTopRightNeighbourCell();
	
	public GRID_CELL moveToBottomLeftNeighbourCell();
	
	public GRID_CELL moveToBottomRightNeighbourCell();	
	
	public GRID_CELL moveToNeighbourCellInDirection(Location direction);
	
	public List<GRID_CELL> getListOfNeighbouringCells();
	
	public GRID_CELL getCell();
	
	public LinkedList<GRID_CELL_ID> getCellsInRadiusOf(float radius);	
}
