package cz.cuni.amis.pogamut.defcon.communication.worldview;

import javabot.PogamutJBotSupport;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.IFlagChecker;

/**
 * Implements common methods to all map sources.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public abstract class AbstractMapSource implements IFlagChecker {

	public static final double STEP = 1d;

	@Override
	public DefConLocation traceFromTo(DefConLocation start, DefConLocation end,
			BasicFlag flag) {

		Location direction = end.sub(start);
		Location step = direction.getNormalized().scale(STEP);
		DefConLocation working = new DefConLocation(end);

		while (direction.dot(working.sub(start)) > 0) {
			if (hasFlag(working, flag))
				return working;

			working.setTo(
					working.getX() - step.getX(),
					working.getY() - step.getY(),
					0);

		}

		return hasFlag(start, flag) ? start : null;
	}

	@Override
	public DefConLocation traceFromTo(DefConLocation start, DefConLocation end,
			BasicFlag flag,
			double distance) {

		Location direction = end.sub(start);
		Location step = direction.getNormalized().scale(STEP);

		DefConLocation working = new DefConLocation(end);
		DefConLocation lastLocation = new DefConLocation();
		DefConLocation okLocation = null;

		// square distance is easier to compute
		distance *= distance;

		// PogamutJBotSupport.writeToConsole("direction: " + direction +
		// " "
		// + step + " " + working + " " + start + " " + end);

		while (direction.dot(working.sub(start)) > 0) {
			if (hasFlag(working, flag)) {

				lastLocation.setTo(working);

				if (okLocation == null) {
					okLocation = new DefConLocation(lastLocation);
				}
			} else {
				okLocation = null;
			}

			if (okLocation != null) {
				double dist = okLocation.getDistanceSquare(working);
				// PogamutJBotSupport.writeToConsole("okLocationdist: "
				// + okLocation + " " + Math.sqrt(dist));
				if (dist > distance) {
					return new DefConLocation(lastLocation);
				}
			}

			working.setTo(
					working.getX() - step.getX(),
					working.getY() - step.getY());
			// PogamutJBotSupport.writeToConsole("direction: " + direction +
			// " "
			// + step + " " + working + " " + start + " " + end);
		}

		if (okLocation != null)
			return okLocation;

		if (!hasFlag(start, flag))
			PogamutJBotSupport
					.writeToConsole("TraceFromTo: Flag start invalid " + start);
		return hasFlag(start, flag) ? start : null;
	}
}
