package cz.cuni.amis.pogamut.defcon.communication.messages.infos;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.Updatable;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.consts.state.IState;


/*
 * Basic object for all units
 *
 * @author Jimmy
 * @author Black_Hand
 */
/**
 * DOCUMENT ME!
 *
 * @author $author$
 * @version $Revision$
  *
 * @param <T> DOCUMENT ME!
 */
public class DefConUnitObject<T extends IState> extends DefConViewableObject {
    /**
     * Current state of of the object. Exposed by getState().
     */
    @Updatable
    private T state;

    /**
     * Current count of activations of units state. Exposed by getStateCount().
     */
    @Updatable
    private int stateCount;

    /**
     * Current target of this unit. Exposed by getTarget().
     */
    @Updatable
    private int target;

/**
     * Construtor of DefConUnitObject.
     *
     * @param id
     * @param type DOCUMENT ME!
     * @param teamId DOCUMENT ME!
     * @param location DOCUMENT ME!
     * @param visible visibility of this object
     * @param state observed state of UnitObject
     * @param stateCount DOCUMENT ME!
     * @param target DOCUMENT ME!
     * @param time
     */
    public DefConUnitObject(int id, UnitType type, int teamId, DefConLocation location,
        boolean visible, T state, int stateCount, int target, double time) {
        super(id, type, teamId, location, visible, time);

        this.state = state;
        this.stateCount = stateCount;
        this.target = target;
    }

/**
     * Creates a new DefConUnitObject object.
     *
     * @param original DOCUMENT ME!
     */
    public DefConUnitObject(DefConUnitObject<T> original) {
        super(original);

        this.state = original.state;
        this.stateCount = original.stateCount;
        this.target = original.target;
    }

    /**
     * Gets current state of the object.
     *
     * @return state
     */
    public T getState() {
        return state;
    }

    /**
     * Sets current state of the object.
     *
     * @param state
     */
    protected void setState(T state) {
        this.state = state;
    }

    /**
     * Gets number of activations of this object's state.
     *
     * @return activations
     */
    public int getStateCount() {
        return stateCount;
    }

    /**
     * Sets number of activations of this object's state.
     *
     * @param stateCount activation
     */
    protected void setStateCount(int stateCount) {
        this.stateCount = stateCount;
    }

    /**
     * Gets current target of this object.
     *
     * @return
     */
    public int getTarget() {
        return target;
    }

    /**
     * Sets current target of this object.
     *
     * @param target
     */
    protected void setTarget(int target) {
        this.target = target;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public String getStringizedFields() {
        return super.getStringizedFields() + "; state: " +
        ((state != null) ? state.toString() : "none") + "; stateCount: " + stateCount +
        "; target: " + target;
    }
}
