package cz.cuni.amis.pogamut.defcon.agent;

/**
 * Specified a list of basic methods for Defcon controllers, which is used inside DefConAgent to
 * report various states of initialization of the game to the controller.
 * Equivalent to IUT2004BotController&lt;BOT&gt; for example in the project PogamutUT2004.
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <AGENT>
 */
public interface IDefConAgentController<AGENT extends DefConAgent> {
	
	/**
	 * Called during the construction of the {@link DefConAgent}.
	 * 
	 * @param agent
	 */	
	public void initializeController(AGENT agent);	

    /**
     * Called whenever the bot is stopped (has finished) or killed.
     * <p><p>
     * Use the method to save your work / data collected during the run of the agent.
     */
    public void botStopped();	
}
