/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.agent.impl.ILogicUpdateListener;
import cz.cuni.amis.pogamut.defcon.ai.fleetai.IFleetAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.PlaceFleet;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.IPlacingFinishedListener;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;

public class FleetsManager {
    protected final DefConAgentLogicController<?> logic;
    protected final SortedMap<Integer, List<Fleet>> enemyFleets = new TreeMap<Integer, List<Fleet>>();
    protected final ArrayList<FleetWithAI> ownFleets = new ArrayList();
    protected final int ownTeamId;
    protected final LinkedList<QueuedPlacing> queuedPlacings = new LinkedList();
    protected final LinkedList<QueuedPlacing> oldPlacings = new LinkedList();
    protected final IWorldObjectListener<Fleet> listener = new IWorldObjectListener<Fleet>(){

        public void notify(IWorldObjectEvent<Fleet> event) {
            if (event instanceof WorldObjectFirstEncounteredEvent) {
                FleetsManager.this.addFleet((Fleet)event.getObject());
            }
            if (event instanceof WorldObjectDestroyedEvent) {
                FleetsManager.this.removeFleet((Fleet)event.getObject());
            }
        }
    };
    protected final ILogicUpdateListener logicUpdateListener = new ILogicUpdateListener(){

        @Override
        public void update() {
            if (!FleetsManager.this.queuedPlacings.isEmpty()) {
                FleetsManager.this.queuedPlacings.peek().refresh();
            }
            for (FleetWithAI fleet : FleetsManager.this.ownFleets) {
                IFleetAI ai = fleet.getAI();
                if (ai == null) continue;
                ai.update();
            }
        }
    };

    protected boolean queuePlacingsContain(Location location) {
        for (QueuedPlacing placing : this.queuedPlacings) {
            if (placing.getLast() == null || !((Object)placing.getLast()).equals(location)) continue;
            return true;
        }
        return false;
    }

    @Inject
    public FleetsManager(DefConAgentLogicController<?> logic) {
        this.ownTeamId = logic.getWorldView().getGameInfo().getOwnTeamId();
        this.logic = logic;
        logic.getWorldView().addObjectListener(Fleet.class, (IWorldObjectEventListener)this.listener);
        logic.addGameLogicListener(this.logicUpdateListener);
    }

    protected void addFleet(Fleet fleet) {
        if (fleet.getTeamId() == this.ownTeamId) {
            this.addOwnFleet(fleet);
        } else {
            this.addEnemyFleet(fleet);
        }
    }

    protected void removeFleet(Fleet fleet) {
        if (fleet.getTeamId() == this.ownTeamId) {
            this.removeOwnFleet(fleet);
        } else {
            this.removeEnemyFleet(fleet);
        }
    }

    protected void addEnemyFleet(Fleet fleet) {
        int enemyId = fleet.getTeamId();
        List singleEnemyFleets = (List)this.enemyFleets.get(enemyId);
        if (!singleEnemyFleets.contains(fleet)) {
            singleEnemyFleets.add(fleet);
        }
    }

    protected void removeEnemyFleet(Fleet fleet) {
        int enemyId = fleet.getTeamId();
        List singleEnemyFleets = (List)this.enemyFleets.get(enemyId);
        if (singleEnemyFleets.contains(fleet)) {
            this.logic.getLog().info("Removing enemy fleet: " + fleet.getId());
            singleEnemyFleets.remove(fleet);
        }
    }

    protected void addOwnFleet(Fleet fleet) {
        if (!this.ownFleets.contains(fleet)) {
            this.ownFleets.add(new FleetWithAI(fleet, null));
            this.logic.getLog().info("Placed fleet to: " + (Object)((Object)fleet.getLocation()) + " " + fleet.getId());
        } else {
            this.logic.getLog().info("WUT?! Placed fleet to: " + (Object)((Object)fleet.getLocation()) + " " + fleet.getId());
        }
        for (QueuedPlacing placings : this.queuedPlacings) {
            for (DefConLocation loc : placings.getLast()) {
                if (!loc.equals(fleet.getLocation())) continue;
                placings.successfulPlacement(fleet);
                return;
            }
        }
        for (QueuedPlacing placings : this.oldPlacings) {
            for (DefConLocation loc : placings.getLast()) {
                if (!loc.equals(fleet.getLocation())) continue;
                placings.successfulPlacement(fleet);
                return;
            }
        }
    }

    protected void removeOwnFleet(Fleet fleet) {
        Iterator<FleetWithAI> ownFleetsIterator = this.ownFleets.iterator();
        while (ownFleetsIterator.hasNext()) {
            FleetWithAI ownFleet = ownFleetsIterator.next();
            if (ownFleet.fleet.getId().getLongId() != fleet.getId().getLongId()) continue;
            this.logic.getLog().info("Removing own fleet: " + fleet.getId());
            ownFleetsIterator.remove();
            if (ownFleet.getAI() == null) continue;
            ownFleet.getAI().dispose();
            ownFleet.setAI(null);
            return;
        }
    }

    public SortedMap<Integer, List<Fleet>> getEnemyFleets() {
        return Collections.unmodifiableSortedMap(this.enemyFleets);
    }

    public List<Fleet> getEnemyFleets(int enemyId) {
        return Collections.unmodifiableList((List)this.enemyFleets.get(enemyId));
    }

    public List<FleetWithAI> getOwnFleets() {
        return Collections.unmodifiableList(this.ownFleets);
    }

    public boolean assignAI(Fleet fleet, IFleetAI ai) {
        for (FleetWithAI fleetWithAI : this.ownFleets) {
            if (!fleetWithAI.getFleet().equals(fleet)) continue;
            fleetWithAI.setAI(ai);
            return true;
        }
        return false;
    }

    public boolean assignAI(int fleetId, IFleetAI ai) {
        for (FleetWithAI fleetWithAI : this.ownFleets) {
            if (fleetWithAI.getFleet().getId().getLongId() != (long)fleetId) continue;
            fleetWithAI.setAI(ai);
            return true;
        }
        return false;
    }

    public boolean placeFleet(DefConLocation location, UnitType[] ships, Object initData, IPlacingFinishedListener finishedListener) {
        LinkedList<DefConLocation> tmp = new LinkedList<DefConLocation>();
        tmp.add(location);
        return this.placeFleet(tmp, ships, 1, initData, finishedListener);
    }

    protected boolean isValidPlacement(Location location, int count) {
        return this.logic.getGameInfo().isValidFleetPlacement(location, count);
    }

    protected boolean placeFleetWorker(DefConLocation location, UnitType[] ships) {
        this.logic.getGameInfo().canCreateFleet(ships);
        this.logic.getLog().info(String.format("Placing fleet to: %s.", location.toString()));
        this.logic.getAct().act(new PlaceFleet(location, ships));
        return true;
    }

    public boolean placeFleet(List<DefConLocation> orderedPlacements, UnitType[] fleetComposition, int fleetsCount, Object initData, IPlacingFinishedListener finishedListener) {
        if (fleetsCount <= 0 || orderedPlacements.size() < fleetsCount) {
            return false;
        }
        LinkedList<DefConLocation> placements = new LinkedList<DefConLocation>();
        for (DefConLocation placement : orderedPlacements) {
            placements.addLast(placement);
        }
        ListIterator placementsIterator = placements.listIterator();
        while (placementsIterator.hasNext()) {
            Location location = (Location)placementsIterator.next();
            if (this.isValidPlacement(location, fleetComposition.length)) continue;
            placementsIterator.remove();
            if (placements.size() >= fleetsCount) continue;
            break;
        }
        if (placements.size() < fleetsCount) {
            return false;
        }
        QueuedPlacing placing = new QueuedPlacing(fleetsCount, fleetComposition, placements, initData, finishedListener);
        this.queuedPlacings.add(placing);
        if (this.queuedPlacings.size() == 1) {
            placing.doPlace();
        }
        return true;
    }

    protected class QueuedPlacing {
        protected final Queue<DefConLocation> placementOptions;
        protected final IPlacingFinishedListener callback;
        protected final int expectedCount;
        protected final Object data;
        protected final ArrayList<Fleet> succeeded = new ArrayList();
        protected final List<DefConLocation> last = new ArrayList<DefConLocation>();
        protected final UnitType[] fleetComposition;
        protected double lastPlacementTime;
        protected static final double LAST_PLACEMENT_MS_LIMIT = 2500.0;

        public QueuedPlacing(int expectedCount, UnitType[] fleetComposition, Queue<DefConLocation> placementOptions, Object data, IPlacingFinishedListener callback) {
            if (expectedCount <= 0 || fleetComposition == null || placementOptions == null || placementOptions.size() < expectedCount) {
                throw new IllegalArgumentException("Invalid parameters for QueuedPlacing.");
            }
            for (int teamId : FleetsManager.this.logic.getGameInfo().getEnemyTeamIds()) {
                FleetsManager.this.enemyFleets.put(teamId, new ArrayList());
            }
            this.expectedCount = expectedCount;
            this.placementOptions = placementOptions;
            this.callback = callback;
            this.data = data;
            this.fleetComposition = fleetComposition;
        }

        public final Queue<DefConLocation> getPlacementOptions() {
            return this.placementOptions;
        }

        public final int getExpectedCount() {
            return this.expectedCount;
        }

        public final List<DefConLocation> getLast() {
            return this.last;
        }

        public final void doPlace() {
            if (this.succeeded.size() + this.placementOptions.size() < this.expectedCount || !FleetsManager.this.logic.getGameInfo().canCreateFleet(this.fleetComposition)) {
                FleetsManager.this.queuedPlacings.remove(this);
                FleetsManager.this.oldPlacings.add(this);
                if (this.callback != null) {
                    this.callback.placingFinished(this.succeeded, this.data, false);
                }
                return;
            }
            int lastCount = this.last.size();
            DefConLocation location = null;
            while (!this.placementOptions.isEmpty() && lastCount == this.last.size()) {
                location = this.placementOptions.poll();
                if (FleetsManager.this.queuePlacingsContain(location) || !FleetsManager.this.isValidPlacement(location, this.fleetComposition.length)) continue;
                this.last.add(location);
                break;
            }
            if (lastCount == this.last.size()) {
                return;
            }
            this.lastPlacementTime = System.currentTimeMillis();
            if (!FleetsManager.this.placeFleetWorker(location, this.fleetComposition)) {
                FleetsManager.this.oldPlacings.add(this);
                FleetsManager.this.queuedPlacings.remove(this);
                if (this.callback != null) {
                    this.callback.placingFinished(this.succeeded, this.data, false);
                }
            }
        }

        public final void successfulPlacement(Fleet fleet) {
            this.succeeded.add(fleet);
            if (this.succeeded.size() == this.expectedCount) {
                FleetsManager.this.queuedPlacings.remove(this);
                FleetsManager.this.oldPlacings.remove(this);
                if (this.callback != null) {
                    this.callback.placingFinished(this.succeeded, this.data, true);
                }
            } else {
                this.doPlace();
            }
        }

        public void refresh() {
            if ((double)System.currentTimeMillis() - this.lastPlacementTime > 2500.0) {
                this.doPlace();
            }
        }
    }

    public class FleetWithAI {
        Fleet fleet;
        IFleetAI ai;

        public FleetWithAI(Fleet fleet, IFleetAI ai) {
            this.fleet = fleet;
            this.ai = ai;
        }

        public final IFleetAI getAI() {
            return this.ai;
        }

        public final void setAI(IFleetAI ai) {
            this.ai = ai;
        }

        public final Fleet getFleet() {
            return this.fleet;
        }
    }
}

