/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings;

import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.GameMapInfoPolygons;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeBFSIterator;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreesManager;
import java.util.ArrayList;
import java.util.List;

public class BuildingPlacementProvider {
    private DefConAgentLogicController<?> logic;
    private GameMapInfoPolygons mapInfo;
    private QuadTreesManager qTreesManager;

    public BuildingPlacementProvider(DefConAgentLogicController<?> logic, GameMapInfoPolygons mapInfo, QuadTreesManager qTreesManager) {
        this.logic = logic;
        this.mapInfo = mapInfo;
        this.qTreesManager = qTreesManager;
    }

    public List<DefConLocation> getLocations(double minDistance, int count, UnitType buildingType) {
        ArrayList<DefConLocation> locations = new ArrayList<DefConLocation>();
        while (count > locations.size() && minDistance >= 5.0) {
            this.collectLocationsForBuildings(locations, minDistance, count, buildingType);
            minDistance -= 5.0;
        }
        return locations;
    }

    private void collectLocationsForBuildings(ArrayList<DefConLocation> locations, double minDistance, int count, UnitType buildingType) {
        for (Pair<List<QuadTree>, List<QuadTree>> territory : this.qTreesManager.getOwnQuadTrees().values()) {
            for (QuadTree qTree : (List)territory.second) {
                QuadTreeBFSIterator nodeIterator = new QuadTreeBFSIterator(qTree);
                while (nodeIterator.hasNext()) {
                    QuadTreeNode node = (QuadTreeNode)nodeIterator.next();
                    if (node.getNodes() != null || !node.isLabeled()) continue;
                    boolean far_enough_from_others = true;
                    Class<? extends DefConObject> buildingClass = buildingType.getClassOfUnitType();
                    for (DefConUnitObject other_buildings : this.logic.getWorldView().getAll(buildingClass).values()) {
                        if (other_buildings.getTeamId() != this.logic.getGameInfo().getOwnTeamId() || this.logic.getGameInfo().isValidBuildingPlacementLocation(node.getCenter()) && !(other_buildings.getLocation().getDistance2D(node.getCenter()) < minDistance)) continue;
                        far_enough_from_others = false;
                        break;
                    }
                    if (far_enough_from_others) {
                        for (DefConLocation other : locations) {
                            if (this.logic.getGameInfo().isValidBuildingPlacementLocation(node.getCenter()) && !(other.getDistance2D(node.getCenter()) < minDistance)) continue;
                            far_enough_from_others = false;
                            break;
                        }
                    }
                    if (!far_enough_from_others) continue;
                    locations.add(new DefConLocation(node.getCenter()));
                    if (locations.size() < count) continue;
                    return;
                }
            }
        }
    }
}

