/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public abstract class LogPublisher
implements ILogPublisher {
    protected Formatter formatter = null;

    public LogPublisher() {
        this.formatter = new LogFormatter();
    }

    public LogPublisher(IAgentId name) {
        this.formatter = new LogFormatter(name);
    }

    public LogPublisher(Formatter formatter) {
        this.formatter = formatter;
        if (this.formatter == null) {
            formatter = new LogFormatter();
        }
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public abstract void close() throws SecurityException;

    @Override
    public abstract void flush();

    public abstract void publish(LogRecord var1, String var2);

    @Override
    public synchronized void publish(LogRecord record) {
        Formatter actualFormatter = this.formatter;
        if (actualFormatter != null) {
            this.publish(record, actualFormatter.format(record));
        }
    }

    public static class FilePublisher
    extends LogPublisher {
        protected File file;
        protected FileOutputStream fileOut;
        protected PrintWriter fileWriter;
        protected boolean immediateFlush = false;

        public FilePublisher(File file) throws PogamutIOException {
            this(file, null);
        }

        public FilePublisher(File file, Formatter formatter) throws PogamutIOException {
            super(formatter);
            NullCheck.check((Object)file, (String)"file");
            this.file = file;
            FilePath.makeDirsToFile((File)file);
            try {
                this.fileOut = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new PogamutIOException("Can't open file '" + file.getAbsolutePath() + "' for logging.", (Throwable)e);
            }
            this.fileWriter = new PrintWriter(this.fileOut);
        }

        public boolean isImmediateFlush() {
            return this.immediateFlush;
        }

        public void setImmediateFlush(boolean immediateFlush) {
            this.immediateFlush = immediateFlush;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() throws SecurityException {
            try {
                this.fileWriter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.fileOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void flush() {
            this.fileWriter.flush();
            try {
                this.fileOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized void publish(LogRecord record, String formattedMsg) {
            this.fileWriter.println(formattedMsg);
            if (this.immediateFlush) {
                this.flush();
            }
        }
    }

    public static class ConsolePublisher
    extends LogPublisher {
        public ConsolePublisher() {
        }

        public ConsolePublisher(IAgentId name) {
            super(name);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record, String formattedMsg) {
            System.out.println(formattedMsg);
        }
    }
}

