/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.utils.timekey;

import cz.cuni.amis.pogamut.multi.utils.exception.TimeKeyNotLockedException;
import cz.cuni.amis.pogamut.multi.utils.timekey.ITimeKeyManager;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TimeKeyManager
implements ITimeKeyManager {
    private HashMap<Long, KeyHolder> locks = new HashMap();
    private static Object instanceCreationMutex = new Object();
    private static TimeKeyManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getHeldKeys() {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            return Collections.unmodifiableSet(new HashSet<Long>(this.locks.keySet()));
        }
    }

    @Override
    public String getHeldKeysStr() {
        ArrayList<Long> keys = new ArrayList<Long>(this.getHeldKeys());
        Collections.sort(keys);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Long key : keys) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(key);
        }
        if (sb.length() == 0) {
            return "nothing";
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeKeyManager get() {
        if (instance != null) {
            return instance;
        }
        Object object = instanceCreationMutex;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            instance = new TimeKeyManager();
            return instance;
        }
    }

    @Override
    public boolean isLocked(TimeKey key) {
        return this.isLocked(key.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked(long time) {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            return this.locks.containsKey(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(long key) throws TimeKeyNotLockedException {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            KeyHolder n = this.locks.get(key);
            if (n == null) {
                throw new TimeKeyNotLockedException("Trying to lock an unlocked " + key);
            }
            if (n.data <= 0L) {
                throw new PogamutException("Locks corrupted! " + key + " locks == " + n + " <= 0, ILLEGAL!", (Object)this);
            }
            if (n.data == 1L) {
                this.locks.remove(key);
            } else {
                --n.data;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(long key) throws TimeKeyNotLockedException {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            KeyHolder n = this.locks.get(key);
            if (n == null) {
                throw new TimeKeyNotLockedException("Trying to lock an unlocked " + key);
            }
            this.locks.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(long key) {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            KeyHolder n = this.locks.get(key);
            if (n == null) {
                this.locks.put(key, new KeyHolder(key, 1L));
            } else {
                ++n.data;
            }
        }
    }

    private TimeKeyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unlockAll() {
        HashMap<Long, KeyHolder> hashMap = this.locks;
        synchronized (hashMap) {
            Long time;
            while (this.locks.size() > 0 && (time = this.locks.keySet().iterator().next()) != null) {
                try {
                    this.unlockAll(time);
                }
                catch (TimeKeyNotLockedException timeKeyNotLockedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private static class KeyHolder {
        public long data;
        public TimeKey timeKey;

        public KeyHolder() {
            this(null, 0L);
        }

        public KeyHolder(long key, long data) {
            this.timeKey = TimeKey.get(key);
            this.data = data;
        }

        public KeyHolder(TimeKey key, long data) {
            this.timeKey = key;
            this.data = data;
        }
    }
}

