/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.marks;

import java.io.Serializable;
import java.util.Calendar;
import java.util.logging.Level;

public class LogEventMark
implements Serializable {
    private static int lastAssignedID = 0;
    private final int id;
    private final Level level;
    private final String text;
    private final long time;
    private final long duration;
    private Type type;

    private LogEventMark(int id, Level level, String text, long time, long duration, Type type) {
        this.id = id;
        this.level = level;
        this.text = text;
        this.time = time;
        this.duration = duration;
        this.type = type;
    }

    private LogEventMark(Level level, String text, long duration, Type type) {
        this(++lastAssignedID, level, text, Calendar.getInstance().getTimeInMillis(), duration, type);
    }

    public static synchronized LogEventMark createSingleLengthEvent(Level level, String text) {
        return new LogEventMark(level, text, 0L, Type.SINGLE_EVENT);
    }

    public static synchronized LogEventMark createFixedLengthEvent(Level level, String text, long duration) {
        return new LogEventMark(level, text, duration, Type.FIXED_DURATION);
    }

    public static synchronized LogEventMark createVariableLengthEvent(Level level, String text) {
        return new LogEventMark(level, text, Integer.MAX_VALUE, Type.START_EVENT);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getText();
    }

    public int getId() {
        return this.id;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public long getTime() {
        return this.time;
    }

    public Type getType() {
        return this.type;
    }

    public long getDuration() {
        return this.duration;
    }

    public LogEventMark getEndMark() {
        switch (this.getType()) {
            case START_EVENT: {
                return new LogEventMark(this.id, this.level, this.text, this.time, this.duration, Type.END_EVENT);
            }
            case END_EVENT: {
                return this;
            }
        }
        throw new IllegalStateException("Unexpected type of mark: " + (Object)((Object)this.getType()));
    }

    public boolean equals(Object otherObject) {
        boolean textEqual;
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof LogEventMark)) {
            return false;
        }
        LogEventMark other = (LogEventMark)otherObject;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getLevel().equals(other.getLevel())) {
            return false;
        }
        boolean bl = this.getText() == null ? other.getText() == null : (textEqual = this.getText().equals(other.getText()));
        if (!textEqual) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        return this.getType() == other.getType();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.id;
        hash = 67 * hash + (this.level != null ? this.level.hashCode() : 0);
        hash = 67 * hash + (this.text != null ? this.text.hashCode() : 0);
        hash = 67 * hash + (int)(this.time ^ this.time >>> 32);
        hash = 67 * hash + (int)(this.duration ^ this.duration >>> 32);
        return hash;
    }

    public static enum Type {
        SINGLE_EVENT,
        FIXED_DURATION,
        START_EVENT,
        END_EVENT;

    }
}

