/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection.impl;

import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.WorldReader;
import cz.cuni.amis.pogamut.base.communication.connection.WorldWriter;
import cz.cuni.amis.pogamut.base.communication.connection.exception.AlreadyConnectedException;
import cz.cuni.amis.pogamut.base.communication.connection.exception.ConnectionException;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.StringCutter;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public abstract class AbstractConnection<ADDRESS extends IWorldConnectionAddress>
implements IWorldConnection<ADDRESS> {
    public static final Token COMPONENT_ID = Tokens.get((String)"Connection");
    public static final String DEFAULT_LINE_END = "\r\n";
    private int connectionToken = 0;
    private Object mutex = new Object();
    protected ADDRESS address = null;
    private ConnectionWriter writer = new ConnectionWriter(this);
    private ConnectionReader reader = new ConnectionReader(this);
    protected LogCategory log = null;
    protected IComponentBus eventBus;
    protected ComponentController<IComponent> controller;
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void stop() {
            this.cleanUp();
        }

        @Override
        public void startPaused() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Object object = AbstractConnection.this.mutex;
            synchronized (object) {
                if (AbstractConnection.this.address == null) {
                    throw new ConnectionException("address is null, can't connect()", AbstractConnection.this.log, (Object)this);
                }
                if (AbstractConnection.this.log.isLoggable(Level.WARNING)) {
                    AbstractConnection.this.log.warning("Connecting to " + AbstractConnection.this.address + ".");
                }
                AbstractConnection.this.unsyncConnect(AbstractConnection.this.address);
            }
        }

        @Override
        public void kill() {
            this.cleanUp();
        }

        @Override
        public void reset() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            Object object = AbstractConnection.this.mutex;
            synchronized (object) {
                try {
                    AbstractConnection.this.reader.reader = null;
                    AbstractConnection.this.writer.writer = null;
                    AbstractConnection.this.unsyncClose();
                }
                finally {
                    AbstractConnection abstractConnection = AbstractConnection.this;
                    abstractConnection.connectionToken = abstractConnection.connectionToken + 1;
                }
            }
        }
    };

    protected abstract void unsyncConnect(ADDRESS var1) throws ConnectionException;

    protected abstract void unsyncClose();

    protected abstract Reader getConnectionReader() throws ConnectionException;

    protected abstract Writer getConnectionWriter() throws ConnectionException;

    public AbstractConnection(ComponentDependencies dependencies, IComponentBus bus, IAgentLogger logger) {
        this(null, dependencies, bus, logger);
    }

    public AbstractConnection(ADDRESS address, ComponentDependencies dependencies, IComponentBus bus, IAgentLogger logger) {
        this.log = logger.getCategory(this.getComponentId().getToken());
        NullCheck.check((Object)this.log, (String)"log initialization");
        this.eventBus = bus;
        NullCheck.check((Object)this.eventBus, (String)"eventBus");
        this.controller = new ComponentController<AbstractConnection>(this, this.control, this.eventBus, (Logger)this.log, dependencies);
        if (address != null) {
            this.setAddress(address);
        }
    }

    public Token getComponentId() {
        return COMPONENT_ID;
    }

    public LogCategory getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAddress(ADDRESS address) throws ConnectionException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.controller.isRunning()) {
                throw new AlreadyConnectedException("Can't set address when connected.", this.log, (Object)this);
            }
            this.address = address;
        }
    }

    @Override
    public WorldWriter getWriter() throws ConnectionException {
        return this.writer;
    }

    @Override
    public WorldReader getReader() throws ConnectionException {
        return this.reader;
    }

    @Override
    public ADDRESS getAddress() {
        return this.address;
    }

    public String toString() {
        if (this != null) {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + String.valueOf(this.address) + ",connected:" + this.controller.isRunning() + "]";
        }
        return "AbstractConnection[" + String.valueOf(this.address) + ",connected:" + this.controller.isRunning() + ")";
    }

    @Override
    public void setLogMessages(boolean logMessages) {
        this.reader.setLogMessages(logMessages);
        this.writer.setLogMessages(logMessages);
    }

    public String getMessageEnd() {
        return DEFAULT_LINE_END;
    }

    private class ConnectionReader
    extends WorldReader {
        private AbstractConnection<ADDRESS> owner = null;
        private StringCutter line;
        private Reader reader;
        private int currentConnectionToken;
        private Object logMessagesMutex;
        private boolean logMessages;

        public ConnectionReader(AbstractConnection<ADDRESS> owner) {
            this.line = new StringCutter(AbstractConnection.this.getMessageEnd());
            this.reader = null;
            this.currentConnectionToken = -1;
            this.logMessagesMutex = new Object();
            this.logMessages = false;
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLogMessages(boolean state) {
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages == state) {
                    return;
                }
                this.logMessages = state;
                if (this.logMessages) {
                    this.line.clear();
                }
            }
        }

        @Override
        public void close() {
            if (AbstractConnection.this.controller.isRunning()) {
                this.owner.controller.manualStop("connection close() requested");
            }
        }

        @Override
        public boolean ready() throws PogamutIOException {
            block4: {
                if (AbstractConnection.this.controller.isRunning()) break block4;
                return false;
            }
            try {
                Reader currentReader = this.getReader();
                if (currentReader != null) {
                    return currentReader.ready();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(char[] ac, int i, int j) throws ComponentNotRunningException, ComponentPausedException, PogamutIOException {
            try {
                if (AbstractConnection.this.controller.isPaused()) {
                    throw new ComponentPausedException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
                }
                if (!AbstractConnection.this.controller.isRunning()) {
                    throw new ComponentNotRunningException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
                }
                Reader currentReader = this.getReader();
                if (currentReader == null) {
                    throw new PogamutIOException("inner reader of the connection is null, can't read", (Object)this);
                }
                int result = currentReader.read(ac, i, j);
                if (this.logMessages) {
                    Object object = this.logMessagesMutex;
                    synchronized (object) {
                        if (this.logMessages) {
                            String[] lines = this.line.add(new String(ac, i, result));
                            int index = 0;
                            while (index < lines.length) {
                                if (AbstractConnection.this.log.isLoggable(Level.INFO)) {
                                    AbstractConnection.this.log.info("Message read: " + lines[index]);
                                }
                                ++index;
                            }
                            return result;
                        }
                    }
                }
                return result;
            }
            catch (Exception e) {
                this.handleException(e);
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reader getReader() throws PogamutIOException {
            Object object = AbstractConnection.this.mutex;
            synchronized (object) {
                if (this.currentConnectionToken != AbstractConnection.this.connectionToken || this.reader == null) {
                    this.currentConnectionToken = AbstractConnection.this.connectionToken;
                    this.line.clear();
                    this.reader = AbstractConnection.this.getConnectionReader();
                }
                return this.reader;
            }
        }

        private void handleException(Throwable e) throws PogamutIOException {
            if (e instanceof PogamutIOException) {
                throw (PogamutIOException)e;
            }
            if (e instanceof ComponentPausedException) {
                throw (ComponentPausedException)((Object)e);
            }
            if (e instanceof ComponentNotRunningException) {
                throw (ComponentNotRunningException)((Object)e);
            }
            if (!AbstractConnection.this.controller.isRunning()) {
                throw new ComponentNotRunningException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
            }
            throw new PogamutIOException(e, (Object)this);
        }

        public String toString() {
            return String.valueOf(AbstractConnection.this.getClass().getSimpleName()) + "-Reader";
        }
    }

    private class ConnectionWriter
    extends WorldWriter {
        private AbstractConnection<ADDRESS> owner = null;
        private StringCutter line;
        private Writer writer;
        private int currentConnectionToken;
        private Object logMessagesMutex;
        private boolean logMessages;

        public ConnectionWriter(AbstractConnection<ADDRESS> owner) {
            this.line = new StringCutter(AbstractConnection.this.getMessageEnd());
            this.writer = null;
            this.currentConnectionToken = -1;
            this.logMessagesMutex = new Object();
            this.logMessages = false;
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLogMessages(boolean state) {
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages == state) {
                    return;
                }
                this.logMessages = state;
                if (this.logMessages) {
                    this.line.clear();
                }
            }
        }

        @Override
        public void close() {
            if (AbstractConnection.this.controller.isRunning()) {
                AbstractConnection.this.controller.manualStop("connection close() requested");
            }
        }

        @Override
        public void flush() throws PogamutIOException {
            try {
                Writer currentWriter = this.getWriter();
                if (currentWriter != null) {
                    currentWriter.flush();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        @Override
        public boolean ready() throws PogamutIOException {
            block3: {
                try {
                    if (AbstractConnection.this.controller.isRunning()) break block3;
                    return false;
                }
                catch (Exception e) {
                    this.handleException(e);
                    return false;
                }
            }
            Writer currentWriter = this.getWriter();
            return currentWriter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void write(char[] cbuf, int off, int len) throws PogamutIOException, ComponentNotRunningException {
            block11: {
                try {
                    if (AbstractConnection.this.controller.isPaused()) {
                        throw new ComponentPausedException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
                    }
                    if (!AbstractConnection.this.controller.isRunning()) {
                        throw new ComponentNotRunningException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
                    }
                    Writer currentWriter = this.getWriter();
                    if (currentWriter == null) {
                        throw new PogamutIOException("inner reader of the connection is null, can't read", (Object)this);
                    }
                    currentWriter.write(cbuf, off, len);
                    if (!this.logMessages) break block11;
                    Object object = this.logMessagesMutex;
                    synchronized (object) {
                        if (this.logMessages) {
                            String[] lines = this.line.add(new String(cbuf, off, len));
                            int index = 0;
                            while (index < lines.length) {
                                if (AbstractConnection.this.log.isLoggable(Level.INFO)) {
                                    AbstractConnection.this.log.info("Message written: " + lines[index]);
                                }
                                ++index;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Writer getWriter() throws PogamutIOException {
            Object object = AbstractConnection.this.mutex;
            synchronized (object) {
                if (this.currentConnectionToken != AbstractConnection.this.connectionToken || this.writer == null) {
                    this.currentConnectionToken = AbstractConnection.this.connectionToken;
                    this.line.clear();
                    this.writer = AbstractConnection.this.getConnectionWriter();
                }
                return this.writer;
            }
        }

        private void handleException(Throwable e) throws PogamutIOException {
            if (e instanceof PogamutIOException) {
                throw (PogamutIOException)e;
            }
            if (e instanceof ComponentPausedException) {
                throw (ComponentPausedException)((Object)e);
            }
            if (e instanceof ComponentNotRunningException) {
                throw (ComponentNotRunningException)((Object)e);
            }
            if (!AbstractConnection.this.controller.isRunning()) {
                throw new ComponentNotRunningException((ComponentState)((Object)AbstractConnection.this.controller.getState().getFlag()), (Object)this);
            }
            throw new PogamutIOException(e, (Object)this);
        }

        public String toString() {
            return String.valueOf(AbstractConnection.this.getClass().getSimpleName()) + "-Writer";
        }
    }
}

