/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation.impl;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.BasePathExecutorState;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.future.FutureStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPathExecutor<PATH_ELEMENT>
implements IPathExecutor<PATH_ELEMENT> {
    protected Flag<IPathExecutorState> state = new Flag((Object)new BasePathExecutorState(PathExecutorState.INSTANTIATED));
    protected List<IStuckDetector> stuckDetectors = new ArrayList<IStuckDetector>();
    protected Logger log;

    public AbstractPathExecutor() {
        this(null);
    }

    public AbstractPathExecutor(Logger log) {
        this.log = log;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    protected void switchState(IPathExecutorState newState) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest("new state " + (Object)((Object)newState.getState()));
        }
        this.state.setFlag((Object)newState);
    }

    @Override
    public ImmutableFlag<IPathExecutorState> getState() {
        return this.state.getImmutable();
    }

    @Override
    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.add(stuckDetector);
    }

    @Override
    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.remove(stuckDetector);
    }

    @Override
    public void removeAllStuckDetectors() {
        this.stuckDetectors.clear();
    }

    @Override
    public boolean inState(PathExecutorState ... states) {
        IPathExecutorState current = (IPathExecutorState)this.getState().getFlag();
        PathExecutorState[] pathExecutorStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            PathExecutorState state = pathExecutorStateArray[n2];
            if (state == current.getState()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean notInState(PathExecutorState ... states) {
        IPathExecutorState current = (IPathExecutorState)this.getState().getFlag();
        PathExecutorState[] pathExecutorStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            PathExecutorState state = pathExecutorStateArray[n2];
            if (state == current.getState()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public List<PATH_ELEMENT> getPath() {
        if (!this.isExecuting()) {
            return null;
        }
        IPathFuture<PATH_ELEMENT> pathFuture = this.getPathFuture();
        if (pathFuture == null) {
            return null;
        }
        if (pathFuture.getStatus() == FutureStatus.FUTURE_IS_READY) {
            return pathFuture.get();
        }
        return null;
    }

    @Override
    public PATH_ELEMENT getPathElement() {
        int index = this.getPathElementIndex();
        if (index < 0) {
            return null;
        }
        List<PATH_ELEMENT> path = this.getPath();
        if (path == null) {
            return null;
        }
        if (index > 0 && index < path.size()) {
            return path.get(index);
        }
        return null;
    }

    @Override
    public boolean isExecuting() {
        return this.inState(PathExecutorState.FOLLOW_PATH_CALLED, PathExecutorState.PATH_COMPUTED, PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT);
    }

    @Override
    public boolean isTargetReached() {
        return ((IPathExecutorState)this.state.getFlag()).getState() == PathExecutorState.TARGET_REACHED;
    }

    @Override
    public boolean isStuck() {
        return ((IPathExecutorState)this.state.getFlag()).getState() == PathExecutorState.STUCK;
    }

    @Override
    public boolean isPathUnavailable() {
        return ((IPathExecutorState)this.state.getFlag()).getState() == PathExecutorState.PATH_COMPUTATION_FAILED;
    }

    @Override
    public abstract void followPath(IPathFuture<? extends PATH_ELEMENT> var1);

    @Override
    public abstract IPathFuture<PATH_ELEMENT> getPathFuture();

    @Override
    public abstract int getPathElementIndex();

    @Override
    public abstract void stop();
}

