/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.agent.jmx.IJMXEnabled;
import cz.cuni.amis.pogamut.base.agent.jmx.adapter.AgentMBeanAdapter;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutMBeanServer;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@AgentScoped
public class AgentJMXComponents<T extends IAgent> {
    public static final String LOG_CATEGORY_NAME = "AgentJMXComponents";
    public static final String JMX_SERVER_AGENT_NAME_DELIM = "|";
    private PogamutMBeanServer mBeanServer = null;
    private String jmxDomain = null;
    private Set<IJMXEnabled> jmxComponents = new LinkedHashSet<IJMXEnabled>();
    private ObjectName agentJMXName = null;
    private IAgentLogger agentLogger;
    private LogCategory log;
    private T agent;

    @Inject
    public AgentJMXComponents(T agent) {
        this.agent = agent;
        this.agentLogger = agent.getLogger();
        this.log = this.agentLogger.getCategory(LOG_CATEGORY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(IJMXEnabled component) {
        Set<IJMXEnabled> set = this.jmxComponents;
        synchronized (set) {
            if (this.jmxComponents.contains(component)) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Adding new JMX component " + component);
            }
            this.jmxComponents.add(component);
            if (this.isJMXEnabled()) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Enabling JMX component " + component);
                }
                component.enableJMX(this.mBeanServer, this.agentJMXName);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("New JMX component added: " + component);
            }
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public String getJMXDomain() {
        return this.jmxDomain;
    }

    public boolean isJMXEnabled() {
        return this.jmxDomain != null;
    }

    public ObjectName getAgentJMXName() {
        return this.agentJMXName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableJMX() throws JMXAlreadyEnabledException, CantStartJMXException {
        Set<IJMXEnabled> set = this.jmxComponents;
        synchronized (set) {
            if (!this.isJMXEnabled()) {
                this.mBeanServer = new PogamutMBeanServer(Pogamut.getPlatform().getMBeanServer());
                this.jmxDomain = PogamutJMX.getPogamutJMXDomain();
                try {
                    this.agentJMXName = PogamutJMX.getAgentObjectName(this.agent.getComponentId());
                }
                catch (Exception e) {
                    throw new CantStartJMXException("Can't create object name for the agent.", e, this.log, this);
                }
                try {
                    AgentMBeanAdapter agentMBean = this.createAgentMBean(this.agentJMXName, this.mBeanServer);
                    this.mBeanServer.registerMBean(agentMBean, this.agentJMXName);
                }
                catch (Exception ex) {
                    throw new CantStartJMXException("Agent MBean cannot be registered.", ex, this.log, this);
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Enabling JMX.");
                }
                int numOk = 0;
                for (IJMXEnabled jmxComponent : this.jmxComponents) {
                    try {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Starting JMX component: " + jmxComponent);
                        }
                        jmxComponent.enableJMX(this.mBeanServer, this.agentJMXName);
                        ++numOk;
                    }
                    catch (JMXAlreadyEnabledException e) {
                        this.log.log(Level.SEVERE, ExceptionToString.process((String)("IJMXEnabled[class=" + jmxComponent.getClass().getName() + ",name=" + jmxComponent.toString() + "]: states that it's been already enabled."), (Throwable)((Object)e)));
                    }
                    catch (CantStartJMXException e) {
                        if (!this.log.isLoggable(Level.SEVERE)) continue;
                        this.log.severe(ExceptionToString.process((String)("IJMXEnabled[class=" + jmxComponent.getClass().getName() + ",name=" + jmxComponent.toString() + "]: can't start it's JMX."), (Throwable)((Object)e)));
                    }
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(numOk) + " JMX components enabled");
                }
            }
        }
        return String.valueOf(Pogamut.getPlatform().getMBeanServerURL().toString()) + JMX_SERVER_AGENT_NAME_DELIM + this.getAgentJMXName().toString();
    }

    protected AgentMBeanAdapter createAgentMBean(ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return new AgentMBeanAdapter<T>(this.agent, objectName, mbs);
    }

    public void unregisterJMX() {
        if (this.isJMXEnabled()) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Unregistering JMX components.");
            }
            this.mBeanServer.unregisterAll();
        }
    }

    public void registerJMX() {
        if (this.isJMXEnabled()) {
            try {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Re-registering JMX components.");
                }
                this.mBeanServer.registerAll();
            }
            catch (Exception e) {
                throw new CantStartJMXException("JMX components can't be re-registered: " + e.getMessage(), e, (Object)this);
            }
        }
    }
}

