/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent2;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent2Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.tests.BaseTest;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Test;

public class Test11_MultipleAgentRunner_Start2x5Agents
extends BaseTest {
    static final int NUM_AGENTS = 5;

    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    public IAgentDescriptor[] initDescriptors(int numAgents) {
        int i;
        IAgentDescriptor[] result = new IAgentDescriptor[2];
        AgentDescriptor desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent1Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[0] = desc;
        desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent2Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[1] = desc;
        return result;
    }

    @Test
    public void test_start5Agents() {
        int i;
        TestMultipleAgentRunner runner = new TestMultipleAgentRunner();
        System.out.println("Starting 5 agents...");
        List agents = runner.startAgents(this.initDescriptors(5));
        System.out.println("Checking agents classes...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        for (i = 5; i < 10; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent2));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        for (i = 5; i < 10; ++i) {
            Assert.assertTrue((((TestAgent2)((Object)agents.get(i))).getParam() == i - 5 ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Stopping 10 agents...");
        for (i = 0; i < 10; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test11_MultipleAgentRunner_Start2x5Agents test = new Test11_MultipleAgentRunner_Start2x5Agents();
        test.test_start5Agents();
        Test11_MultipleAgentRunner_Start2x5Agents.tearDown();
    }
}

