/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.configuration;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.configuration.PropertyProvider;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class CustomPropertiesProvider
extends PropertyProvider {
    LogCategory log = new LogCategory("CustomPropertiesProvider");
    static final String resource = "PogamutPlatformCustom.properties";
    Properties properties = new Properties();
    File propFile;

    public CustomPropertiesProvider() {
        this.log.addConsoleHandler();
        try {
            this.propFile = new File(resource);
            this.properties.load(new FileInputStream(this.propFile));
        }
        catch (FileNotFoundException e) {
            this.log.warning("Custom property file not found in " + this.propFile.getAbsolutePath() + ".");
        }
        catch (IOException ex) {
            throw new PogamutException("I/O exception while reading the custom Pogamut platform property file 'PogamutPlatformCustom.properties', absolute location '" + this.propFile.getAbsolutePath() + "'.", (Throwable)ex, (Logger)this.log, (Object)this);
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public int getPriority() {
        return 1000;
    }

    public String toString() {
        return "CustomPropertiesProvider[source='" + this.propFile.getAbsolutePath() + "']";
    }
}

