/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.sharedcomponent;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.CheckSharedEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public class ManualCheckSharedComponent
implements IComponent {
    private static int counter = 0;
    private Token token;
    private Queue<CheckSharedEvent> expect = new LinkedList<CheckSharedEvent>();
    private LogCategory log;

    public ManualCheckSharedComponent(IAgentLogger logger) {
        this(logger, new CheckSharedEvent[0]);
    }

    public ManualCheckSharedComponent(IAgentLogger logger, CheckSharedEvent ... events) {
        this.token = Tokens.get((String)("ManualCheckSharedComponent" + counter++));
        this.log = logger.getCategory((IComponent)this);
        NullCheck.check((Object)this.log, (String)"log initialization");
        this.expect(events);
    }

    public void expect(CheckSharedEvent ... events) {
        for (CheckSharedEvent event : events) {
            this.expect(event);
        }
    }

    public void expect(CheckSharedEvent event) {
        this.expect.add(event);
    }

    public int getExpectSize() {
        return this.expect.size();
    }

    public void manualNotify(IAgentId agentId, IComponentEvent<?> event) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Got event: " + event);
        }
        if (this.expect.size() == 0) {
            throw new RuntimeException("No event expected, but " + event.getClass() + " from " + event.getSource() + " of agetn " + agentId + " came.");
        }
        this.expect.poll().check(agentId, event);
    }

    public IToken getComponentId() {
        return this.token;
    }

    public Logger getLog() {
        return this.log;
    }

    public String toString() {
        return this.getComponentId().getToken();
    }

    public void checkExpectEmpty() {
        Assert.assertTrue((String)"should not expect any events", (this.getExpectSize() == 0 ? 1 : 0) != 0);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Does not expecting any new events.");
        }
    }
}

