/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.IVisionLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.AbstractLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalViewable;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.WeakHashMapMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

@AgentScoped
public abstract class VisionLocalWorldView
extends EventDrivenLocalWorldView
implements IVisionLocalWorldView {
    protected Map<TimeKey, Map<WorldObjectId, IViewable>> visibleMap = new WeakHashMap<TimeKey, Map<WorldObjectId, IViewable>>();
    protected Map<TimeKey, Map<WorldObjectId, IViewable>> syncVisibleMap = Collections.synchronizedMap(this.visibleMap);
    protected Map<TimeKey, Map<Class, Map<WorldObjectId, IViewable>>> visibleClassMap = new WeakHashMapMap();
    protected Map<TimeKey, Map<Class, Map<WorldObjectId, IViewable>>> syncVisibleClassMap = Collections.synchronizedMap(this.visibleClassMap);
    private long highestEventTime = -1L;

    public VisionLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
    }

    @Override
    public void notify(IWorldChangeEvent event) {
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent(((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent());
        } else {
            super.notify(event);
        }
    }

    protected void createNewVisibleMaps(long time) {
        TimeKey timeKey = TimeKey.get(time);
        this.syncVisibleMap.put(timeKey, (Map<WorldObjectId, IViewable>)((Object)new AbstractLocalWorldView.LazyCompositeObjectMap(this, timeKey.getTime())));
        if (this.syncVisibleMap.get(TimeKey.get(this.highestEventTime)) != null) {
            this.syncVisibleMap.get(timeKey).keySet().addAll(this.syncVisibleMap.get(TimeKey.get(this.highestEventTime)).keySet());
        }
        for (Class c : this.syncVisibleClassMap.get(TimeKey.get(this.highestEventTime)).keySet()) {
            this.syncVisibleClassMap.get(timeKey).put(c, (Map<WorldObjectId, IViewable>)((Object)new AbstractLocalWorldView.LazyCompositeObjectMap(this, timeKey.getTime())));
            if (this.syncVisibleClassMap.get(this.highestEventTime).get(c) == null) continue;
            this.syncVisibleClassMap.get(timeKey).get(c).keySet().addAll(this.syncVisibleClassMap.get(this.highestEventTime).get(c).keySet());
        }
    }

    @Override
    protected void objectUpdatedEvent(ILocalWorldObjectUpdatedEvent updateEvent) {
        if (updateEvent.getSimTime() > this.highestEventTime) {
            this.createNewVisibleMaps(updateEvent.getSimTime());
            this.highestEventTime = updateEvent.getSimTime();
        }
        ILocalWorldObject obj = this.getMostRecentLocalWorldObject(updateEvent.getId());
        boolean oldVisible = false;
        boolean isViewable = false;
        ILocalWorldObject copy = null;
        if (obj != null) {
            if (obj instanceof ILocalViewable) {
                oldVisible = ((ILocalViewable)obj).isVisible();
                isViewable = true;
            }
            copy = obj.clone();
        } else {
            copy = null;
        }
        IWorldObjectUpdateResult<ILocalWorldObject> updateResult = updateEvent.update(copy);
        switch (updateResult.getResult()) {
            case CREATED: {
                this.objectCreated(updateResult.getObject(), updateEvent.getSimTime());
                return;
            }
            case UPDATED: {
                boolean visible;
                if (updateResult.getObject() != copy) {
                    throw new PogamutException("Update event " + updateEvent + " does not returned the same instance of the object (result UPDATED).", (Object)this);
                }
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                if (isViewable && (visible = ((ILocalViewable)copy).isVisible()) != oldVisible) {
                    if (visible) {
                        this.objectAppeared((ILocalViewable)copy, updateEvent.getSimTime());
                    } else {
                        this.objectDisappeared((ILocalViewable)copy, updateEvent.getSimTime());
                    }
                }
                this.actLocalWorldObjects.put(copy.getId(), copy);
                this.objectUpdated(copy, updateEvent.getSimTime());
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                this.objectDestroyed(copy, updateEvent.getSimTime());
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    @Override
    protected void objectCreated(ILocalWorldObject obj, long time) {
        if (obj instanceof ILocalViewable && ((ILocalViewable)obj).isVisible()) {
            this.objectAppeared((ILocalViewable)obj, time);
        }
        super.objectCreated(obj, time);
    }

    @Override
    protected void objectDestroyed(ILocalWorldObject obj, long time) {
        if (obj instanceof ILocalViewable) {
            this.removeVisible((ILocalViewable)obj, time);
        }
        super.objectDestroyed(obj, time);
    }

    protected void objectAppeared(ILocalViewable obj, long time) {
        this.addVisible(obj, time);
    }

    protected void objectDisappeared(ILocalViewable obj, long time) {
        this.removeVisible(obj, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addVisible(ILocalViewable obj, long time) {
        Map<TimeKey, Map<Serializable, Object>> map = this.visibleMap;
        synchronized (map) {
            ((AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleMap.get(TimeKey.get(time)))).addKey(obj.getId());
        }
        map = this.visibleClassMap;
        synchronized (map) {
            for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map2 = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleClassMap.get(TimeKey.get(time)).get(cls));
                if (map2 == null) {
                    map2 = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.getCurrentTimeKey().getTime());
                    this.visibleClassMap.get(TimeKey.get(time)).put(cls, (Map<WorldObjectId, IViewable>)((Object)map2));
                }
                map2.addKey(obj.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeVisible(ILocalViewable obj, long time) {
        Map<TimeKey, Map<Serializable, Object>> map = this.visibleMap;
        synchronized (map) {
            ((AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleMap.get(TimeKey.get(time)))).remove(obj.getId());
        }
        map = this.visibleClassMap;
        synchronized (map) {
            for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
                AbstractLocalWorldView.LazyCompositeObjectMap map2 = (AbstractLocalWorldView.LazyCompositeObjectMap)((Object)this.visibleClassMap.get(TimeKey.get(time)).get(cls));
                if (map2 == null) {
                    map2 = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.getCurrentTimeKey().getTime());
                    this.visibleClassMap.get(TimeKey.get(time)).put(cls, (Map<WorldObjectId, IViewable>)((Object)map2));
                }
                map2.remove(obj.getId());
            }
        }
    }

    @Override
    public Map<Class, Map<WorldObjectId, IViewable>> getAllVisible() {
        return this.syncVisibleClassMap.get(this.currentTimeKey);
    }

    @Override
    public <T extends IViewable> Map<WorldObjectId, T> getAllVisible(Class<T> type) {
        Object map = this.syncVisibleClassMap.get(this.currentTimeKey).get(type);
        if (map == null) {
            map = new AbstractLocalWorldView.LazyCompositeObjectMap(this, this.currentTimeKey.getTime());
        }
        return map;
    }

    @Override
    public Map<WorldObjectId, IViewable> getVisible() {
        return this.syncVisibleMap.get(this.currentTimeKey);
    }

    @Override
    public IViewable getVisible(WorldObjectId id) {
        return this.syncVisibleMap.get(this.currentTimeKey).get(id);
    }
}

