/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.utils.timekey;

import cz.cuni.amis.pogamut.multi.utils.exception.TimeKeyNotLockedException;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.Test;

public class Test02_TimeKeyManager
extends BaseTest {
    public static Random r = new Random(System.currentTimeMillis());
    private static boolean failure = false;

    @Test(timeout=60000L)
    public void lockUnlockTest() {
        int thrds = 1;
        int runs = 10;
        Thread[] threads = new Thread[thrds];
        for (int i = 0; i < thrds; ++i) {
            threads[i] = new Thread(new Locker(runs, i));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        if (failure) {
            this.assertFail("There was a failure in the test!");
        }
        log.info("Locked: " + TimeKeyManager.get().getHeldKeysStr());
        for (long l = -1000L; l < 1000L; ++l) {
            if (!TimeKeyManager.get().isLocked(l)) continue;
            this.assertFail(" TimeKey  " + l + " still locked");
        }
        threads = null;
        CheckInstances.waitGCTotal();
        System.out.println("---/// TEST OK ///---");
    }

    @Test(timeout=300000L)
    public void lockUnlockTest2() {
        int thrds = 20;
        int runs = 1000;
        Thread[] threads = new Thread[thrds];
        for (int i = 0; i < thrds; ++i) {
            threads[i] = new Thread(new Locker(runs, i));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        if (failure) {
            this.assertFail("There was a failure in the test!");
        }
        log.info("Locked: " + TimeKeyManager.get().getHeldKeysStr());
        for (long l = -1000L; l < 1000L; ++l) {
            if (!TimeKeyManager.get().isLocked(l)) continue;
            this.assertFail(" TimeKey  " + l + " still locked");
        }
        threads = null;
        CheckInstances.waitGCTotal();
        System.out.println("---/// TEST OK ///---");
    }

    private class Locker
    implements Runnable {
        HashSet<Long> locks = new HashSet();
        List<Long> toLock = new ArrayList<Long>();
        private int runs;
        private int id;

        public Locker(int runs, int id) {
            this.runs = runs;
            this.id = id;
            for (long key = 0L; key < (long)runs; ++key) {
                this.toLock.add(key);
            }
            Collections.shuffle(this.toLock);
        }

        protected void makeLock(long l) {
            if (this.locks.contains(l)) {
                return;
            }
            log.fine("Locking : " + l);
            TimeKeyManager.get().lock(l);
            this.locks.add(l);
        }

        protected void removeLock(long l) {
            if (this.locks.contains(l)) {
                this.locks.remove(l);
                log.fine("Unlocking : " + l);
                try {
                    TimeKeyManager.get().unlock(l);
                }
                catch (TimeKeyNotLockedException e) {
                    failure = true;
                    log.severe("Trying to unlock not locked TimeKey : " + l);
                    throw new RuntimeException("Trying to unlock not locked TimeKey : " + l);
                }
            }
        }

        protected void checkLocks() {
            for (Long l : this.locks) {
                if (TimeKeyManager.get().isLocked(l.longValue())) continue;
                failure = true;
                log.severe("TimeKey " + l + " should be locked, but is not!!!");
                throw new RuntimeException("TimeKey " + l + " should be locked, but is not!!!");
            }
        }

        protected void removeLocks() {
            log.info("Thread " + this.id + " : Removing locks");
            while (this.locks.size() > 0) {
                this.removeLock(this.locks.iterator().next());
                this.checkLocks();
            }
            this.locks.clear();
        }

        @Override
        public void run() {
            while (this.runs > 0) {
                if (this.runs % 20 == 0) {
                    log.info("Thread " + this.id + ": " + this.runs + " runs remaining");
                }
                long key = this.toLock.remove(this.toLock.size() - 1);
                this.makeLock(key);
                this.checkLocks();
                --this.runs;
            }
            this.removeLocks();
            log.info("Thread " + this.id + " : Finished.");
        }
    }
}

