/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppingEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.AutoCheckSharedComponent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.EventToString;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.MethodToString;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Test;

public class Test21_SharedComponentController_StartPauseResumeStop
extends BaseTest {
    private void checkState(AutoCheckSharedComponent sharedComp, ComponentState state) {
        if (sharedComp.getController().notInState(new ComponentState[]{state})) {
            String msg = "[ERROR] " + sharedComp.getComponentId().getToken() + " is not in state " + state + " but in state " + sharedComp.getController().getState().getFlag() + ", INVALID!";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }

    @Test
    public void test() {
        AgentId agentId1 = new AgentId("Test21_Shared-Agent1");
        AgentId agentId2 = new AgentId("Test21_Shared-Agent2");
        AgentLogger logger1 = new AgentLogger((IAgentId)agentId1);
        AgentLogger logger2 = new AgentLogger((IAgentId)agentId2);
        logger1.addDefaultConsoleHandler();
        logger1.setLevel(Level.ALL);
        logger2.addDefaultConsoleHandler();
        logger2.setLevel(Level.ALL);
        LifecycleBus bus1 = new LifecycleBus((IAgentLogger)logger1);
        LifecycleBus bus2 = new LifecycleBus((IAgentLogger)logger2);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger1);
        ManualCheckComponent manualComp1_0 = new ManualCheckComponent((IAgentLogger)logger1, (IComponentBus)bus1);
        ManualCheckComponent manualComp1_1 = new ManualCheckComponent((IAgentLogger)logger1, (IComponentBus)bus1);
        ManualCheckComponent manualComp2_2 = new ManualCheckComponent((IAgentLogger)logger2, (IComponentBus)bus2);
        ManualCheckComponent manualComp2_3 = new ManualCheckComponent((IAgentLogger)logger2, (IComponentBus)bus2);
        ComponentControlHelper emptyCtrl = new ComponentControlHelper();
        ComponentController manualCompCtrl1_0 = new ComponentController((IComponent)manualComp1_1, (IComponentControlHelper)emptyCtrl, (ILifecycleBus)bus1, (Logger)logger1.getCategory(manualComp1_1.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)manualComp1_0));
        ComponentController manualCompCtrl2 = new ComponentController((IComponent)manualComp2_3, (IComponentControlHelper)emptyCtrl, (ILifecycleBus)bus2, (Logger)logger2.getCategory(manualComp2_3.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)manualComp2_2));
        sharedComp.addComponentBus((IAgentId)agentId1, (ILifecycleBus)bus1, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)manualComp1_1));
        sharedComp.addComponentBus((IAgentId)agentId2, (ILifecycleBus)bus2, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)manualComp2_3));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId1, manualComp1_0, StartingEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, StartingEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, StartedEvent.class), MethodToString.preStart(sharedComp), MethodToString.start(sharedComp), MethodToString.localPreStart(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, StartingEvent.class), MethodToString.localStart(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, StartedEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_0, StartedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId1, manualComp1_1, PausingEvent.class), MethodToString.localPrePause(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, PausingEvent.class), MethodToString.localPause(sharedComp, (IAgentId)agentId1), MethodToString.prePause(sharedComp), MethodToString.pause(sharedComp), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, PausedEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, PausedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId1, manualComp1_1, ResumingEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, ResumedEvent.class), MethodToString.preResume(sharedComp), MethodToString.resume(sharedComp), MethodToString.localPreResume(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, ResumingEvent.class), MethodToString.localResume(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, ResumedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId1, manualComp1_0, StoppingEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, StoppingEvent.class), MethodToString.localPreStop(sharedComp, (IAgentId)agentId1), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, StoppingEvent.class), MethodToString.localStop(sharedComp, (IAgentId)agentId1), MethodToString.preStop(sharedComp), MethodToString.stop(sharedComp), EventToString.eventToString((IAgentId)agentId1, (IComponent)sharedComp, StoppedEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_1, StoppedEvent.class), EventToString.eventToString((IAgentId)agentId1, manualComp1_0, StoppedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StartingEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StartedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StartingEvent.class), MethodToString.preStart(sharedComp), MethodToString.start(sharedComp), MethodToString.localPreStart(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StartingEvent.class), MethodToString.localStart(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StartedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StartedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId2, manualComp2_3, PausingEvent.class), MethodToString.localPrePause(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, PausingEvent.class), MethodToString.localPause(sharedComp, (IAgentId)agentId2), MethodToString.prePause(sharedComp), MethodToString.pause(sharedComp), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, PausedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, PausedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId2, manualComp2_3, ResumingEvent.class), MethodToString.preResume(sharedComp), MethodToString.resume(sharedComp), MethodToString.localPreResume(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, ResumingEvent.class), MethodToString.localResume(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, ResumedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, ResumedEvent.class));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StoppingEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StoppingEvent.class), MethodToString.localPreStop(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StoppingEvent.class), MethodToString.localStop(sharedComp, (IAgentId)agentId2), MethodToString.preStop(sharedComp), MethodToString.stop(sharedComp), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StoppedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StoppedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StoppedEvent.class));
        manualComp1_0.manualStart();
        this.checkState(sharedComp, ComponentState.RUNNING);
        manualComp1_1.manualPause();
        this.checkState(sharedComp, ComponentState.PAUSED);
        manualComp1_1.manualResume();
        this.checkState(sharedComp, ComponentState.RUNNING);
        manualComp1_0.manualStop();
        this.checkState(sharedComp, ComponentState.STOPPED);
        manualComp2_2.manualStart();
        this.checkState(sharedComp, ComponentState.RUNNING);
        manualComp2_3.manualPause();
        this.checkState(sharedComp, ComponentState.PAUSED);
        manualComp2_3.manualResume();
        this.checkState(sharedComp, ComponentState.RUNNING);
        manualComp2_2.manualStop();
        this.checkState(sharedComp, ComponentState.STOPPED);
        sharedComp.checkNoMoreActivityExpected();
        System.out.println("---/// TEST OK ///---");
    }
}

