/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestLocalObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestStaticObject;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;

public class TestCompositeObjectImpl
extends TestCompositeObject {
    protected TestLocalObject localPart;
    protected TestSharedObject sharedPart;
    protected TestStaticObject staticPart;
    private static FlagInteger instances = new FlagInteger(Integer.valueOf(0));

    public static ImmutableFlag<Integer> getInstances() {
        return instances.getImmutable();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        instances.decrement(1);
    }

    public TestCompositeObjectImpl(TestLocalObject localPart, TestSharedObject sharedPart, TestStaticObject staticPart) {
        super(localPart.getId());
        instances.increment(1);
        this.localPart = localPart;
        if (sharedPart.getId() != this.id || staticPart.getId() != this.getId()) {
            throw new PogamutException("Trying to create composite object from objects with different Ids", (Object)this);
        }
        this.sharedPart = sharedPart;
        this.staticPart = staticPart;
    }

    public ILocalWorldObject getLocal() {
        return this.localPart;
    }

    public ISharedWorldObject getShared() {
        return this.sharedPart;
    }

    public IStaticWorldObject getStatic() {
        return this.staticPart;
    }

    public long getSimTime() {
        if (this.localPart.getSimTime() < this.sharedPart.getSimTime()) {
            return this.sharedPart.getSimTime();
        }
        return this.localPart.getSimTime();
    }

    @Override
    public String getLocalString() {
        return this.localPart.getLocalString();
    }

    @Override
    public long getLocalLong() {
        return this.localPart.getLocalLong();
    }

    @Override
    public String getStaticString() {
        return this.staticPart.getStaticString();
    }

    @Override
    public long getStaticLong() {
        return this.staticPart.getStaticLong();
    }

    @Override
    public String getSharedString() {
        return this.sharedPart.getSharedString();
    }

    @Override
    public long getSharedLong() {
        return this.sharedPart.getSharedLong();
    }

    public String toString() {
        return "TestCompositeObjectImpl[id=" + this.getId() + ", time=" + this.getSimTime() + ", sharedString=" + this.getSharedString() + ", sharedLong=" + this.getSharedLong() + ", localString=" + this.getLocalString() + ", localLong=" + this.getLocalLong() + ", staticString=" + this.getStaticString() + ", staticLong=" + this.getStaticLong() + "]";
    }
}

