/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation.impl;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorHelper;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.BasePathExecutorState;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.future.FutureStatus;
import cz.cuni.amis.utils.future.FutureWithListeners;
import cz.cuni.amis.utils.future.IFutureListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasePathExecutor<PATH_ELEMENT>
extends AbstractPathExecutor<PATH_ELEMENT>
implements IPathExecutorHelper<PATH_ELEMENT> {
    protected Object mutex = new Object();
    protected IPathFuture<PATH_ELEMENT> pathFuture = null;
    protected int previousPathElementIndex = -1;
    private int pathElementIndex = -1;
    IFutureListener<List<PATH_ELEMENT>> pathFutureListener = new IFutureListener<List<PATH_ELEMENT>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void futureEvent(FutureWithListeners<List<PATH_ELEMENT>> source, FutureStatus oldStatus, FutureStatus newStatus) {
            Object object = BasePathExecutor.this.mutex;
            synchronized (object) {
                source.removeFutureListener((IFutureListener)this);
                if (BasePathExecutor.this.pathFuture != source) {
                    return;
                }
                switch (newStatus) {
                    case FUTURE_IS_READY: {
                        BasePathExecutor.this.pathComputed();
                        return;
                    }
                    case COMPUTATION_EXCEPTION: 
                    case CANCELED: {
                        BasePathExecutor.this.pathComputationFailed();
                        return;
                    }
                    case FUTURE_IS_BEING_COMPUTED: {
                        throw new RuntimeException("FutureWithListeners can't change its state to FUTURE_IS_BEING_COMPUTED.");
                    }
                }
            }
        }
    };

    public BasePathExecutor() {
        this(null);
    }

    public BasePathExecutor(Logger log) {
        this.log = log;
    }

    @Override
    public int getPathElementIndex() {
        return this.pathElementIndex;
    }

    @Override
    public IPathFuture<PATH_ELEMENT> getPathFuture() {
        return this.pathFuture;
    }

    protected IPathExecutorState createState(PathExecutorState state) {
        switch (state) {
            case SWITCHED_TO_ANOTHER_PATH_ELEMENT: {
                return new BasePathExecutorState(PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT);
            }
        }
        return BasePathExecutorState.getState(state);
    }

    @Override
    public final void followPath(IPathFuture<? extends PATH_ELEMENT> path) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isExecuting()) {
                this.stop();
            }
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("followPath called, destination " + path.getPathTo());
            }
            this.pathFuture = path;
            this.preFollowPathImpl();
            this.switchState(this.createState(PathExecutorState.FOLLOW_PATH_CALLED));
            this.followPathImpl();
            if (path == null) {
                this.pathComputationFailed();
                return;
            }
            switch (path.getStatus()) {
                case COMPUTATION_EXCEPTION: 
                case CANCELED: {
                    this.pathComputationFailed();
                    return;
                }
                case FUTURE_IS_READY: {
                    if (this.getPath() == null) {
                        this.pathComputationFailed();
                    } else {
                        this.pathComputed();
                    }
                    return;
                }
                case FUTURE_IS_BEING_COMPUTED: {
                    this.pathFuture.addFutureListener(this.pathFutureListener);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled path future status '" + path.getStatus() + "'.");
                }
            }
            switch (path.getStatus()) {
                case COMPUTATION_EXCEPTION: 
                case CANCELED: {
                    this.pathComputationFailed();
                    return;
                }
                case FUTURE_IS_READY: {
                    this.pathComputed();
                    return;
                }
                case FUTURE_IS_BEING_COMPUTED: {
                    return;
                }
            }
            throw new RuntimeException("Unhandled path future status '" + path.getStatus() + "'.");
        }
    }

    protected void preFollowPathImpl() {
        this.previousPathElementIndex = -1;
        this.pathElementIndex = -1;
    }

    protected abstract void followPathImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void pathComputed() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.notInState(PathExecutorState.FOLLOW_PATH_CALLED)) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("path computed, size == " + this.getPath().size());
            }
            this.pathFuture.removeFutureListener(this.pathFutureListener);
            this.prePathComputedImpl();
            this.switchState(this.createState(PathExecutorState.PATH_COMPUTED));
            this.pathComputedImpl();
        }
    }

    protected void prePathComputedImpl() {
        for (IStuckDetector detector : this.stuckDetectors) {
            detector.reset();
        }
    }

    protected abstract void pathComputedImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void pathComputationFailed() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.notInState(PathExecutorState.FOLLOW_PATH_CALLED)) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("path computation failed");
            }
            if (this.pathFuture != null) {
                this.pathFuture.removeFutureListener(this.pathFutureListener);
            }
            this.prePathComputationFailed();
            this.switchState(this.createState(PathExecutorState.PATH_COMPUTATION_FAILED));
            this.pathComputationFailedImpl();
        }
    }

    protected void prePathComputationFailed() {
    }

    protected abstract void pathComputationFailedImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void switchToAnotherPathElement(int index) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isExecuting()) {
                return;
            }
            List path = this.getPath();
            if (path == null) {
                throw new PogamutException("Can't switch to element of index '" + index + "' as the current path executor's path is null.", (Object)this);
            }
            if (index < 0 || index >= path.size()) {
                throw new PogamutException("Can't switch to element of index '" + index + "' as it is out of path range (path.size() = " + path.size() + ").", (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("switching to path element " + (index + 1) + "/" + this.getPath().size() + " -> " + path.get(index));
            }
            this.preSwitchToAnotherPathElementImpl(index);
            this.switchState(this.createState(PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT));
            this.switchToAnotherPathElementImpl();
        }
    }

    protected void preSwitchToAnotherPathElementImpl(int newIndex) {
        this.previousPathElementIndex = this.pathElementIndex;
        this.pathElementIndex = newIndex;
    }

    protected abstract void switchToAnotherPathElementImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inState(PathExecutorState.STOPPED)) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("stop");
            }
            this.stopImpl();
            this.switchState(this.createState(PathExecutorState.STOPPED));
            this.stopped();
        }
    }

    protected void stopImpl() {
        this.previousPathElementIndex = -1;
        this.pathElementIndex = -1;
        if (this.pathFuture != null) {
            this.pathFuture.removeFutureListener(this.pathFutureListener);
            this.pathFuture = null;
        }
    }

    protected abstract void stopped();

    @Override
    public IStuckDetector checkStuckDetectors() {
        for (IStuckDetector detector : this.stuckDetectors) {
            if (!detector.isStuck()) continue;
            return detector;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stuck() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.notInState(PathExecutorState.FOLLOW_PATH_CALLED, PathExecutorState.PATH_COMPUTED, PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT)) {
                return;
            }
            this.preStuckImpl();
            this.switchState(this.createState(PathExecutorState.STUCK));
            this.stuckImpl();
        }
    }

    protected void preStuckImpl() {
    }

    protected abstract void stuckImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void targetReached() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.notInState(PathExecutorState.FOLLOW_PATH_CALLED, PathExecutorState.PATH_COMPUTED, PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT)) {
                return;
            }
            this.preTargetReachedImpl();
            this.switchState(this.createState(PathExecutorState.TARGET_REACHED));
            this.targetReachedImpl();
        }
    }

    protected void preTargetReachedImpl() {
    }

    protected abstract void targetReachedImpl();
}

