/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.mediator;

import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubBeginMessage;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubBombInfo;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubBotDamaged;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubBumped;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubEndMessage;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubGameInfo;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.StubHearPickup;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.LinkedList;
import java.util.logging.Level;
import org.easymock.IAnswer;
import org.junit.Assert;

public class ExpectedAnswersOfMediator
implements IAnswer<IWorldChangeEvent> {
    private LinkedList<IWorldChangeEvent> eventsQueue = new LinkedList();
    private IWorldChangeEvent lastEvent;
    private LogCategory logger;
    private IMediator testedMediator;
    private Flag<Boolean> eventsQueueEmpty = new Flag((Object)true);

    public ExpectedAnswersOfMediator(LogCategory logger, IMediator testedMediator) {
        Assert.assertTrue((String)"Passed logger cannot be empty.", (logger != null ? 1 : 0) != 0);
        this.logger = logger;
        this.eventsQueue.add(new StubBeginMessage());
        this.eventsQueue.add(new StubBombInfo());
        this.eventsQueue.add(new StubBotDamaged());
        this.eventsQueue.add(new StubBumped());
        this.eventsQueue.add(new StubEndMessage());
        this.eventsQueue.add(new StubGameInfo());
        this.eventsQueue.add(new StubHearPickup());
        this.eventsQueueEmpty.setFlag((Object)false);
        this.logger = logger;
        this.testedMediator = testedMediator;
    }

    public ImmutableFlag<Boolean> getEventsQueueEmpty() {
        return this.eventsQueueEmpty.getImmutable();
    }

    public IWorldChangeEvent answer() throws Throwable {
        if (this.eventsQueue.size() > 0) {
            this.lastEvent = this.eventsQueue.pop();
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Returned event: " + this.lastEvent.toString());
            }
        } else {
            this.eventsQueueEmpty.setFlag((Object)true);
            this.lastEvent = null;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Event queue empty");
            }
            Thread.currentThread().interrupt();
        }
        return this.lastEvent;
    }

    public IWorldChangeEvent getLastEvent() {
        return this.lastEvent;
    }

    public int getNumberOfQueuedEvents() {
        return this.eventsQueue.size();
    }

    public LinkedList<IWorldChangeEvent> getList() {
        return this.eventsQueue;
    }
}

