/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentRunner;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.tests.BaseTest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Test;

public class Test06_AgentRunner_LoggingMethods
extends BaseTest {
    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    protected IAgentRunner initAgentRunner() {
        return new TestAgentRunner((IAgentFactory)new GuiceAgentFactory((GuiceAgentModule)new TestAgent1Module())).setConsoleLogging(true).setLogLevel(Level.ALL).setConsoleLogging(true).setLog((Logger)new LogCategory("TestAgent1Runner").addConsoleHandler());
    }

    @Test
    public void test_start1Agent() {
        IAgentRunner runner = this.initAgentRunner();
        System.out.println("Starting 1 agent...");
        IAgent agent = runner.startAgent();
        System.out.println("Checking agents classes...");
        Assert.assertTrue((boolean)(agent instanceof TestAgent1));
        System.out.println("OK");
        System.out.println("Checking agents running...");
        Assert.assertTrue((boolean)((IAgentState)agent.getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        System.out.println("OK");
        System.out.println("Checking agent log level...");
        Assert.assertTrue((boolean)((LogCategory)agent.getLogger().getCategories().values().iterator().next()).getLevel().equals(Level.ALL));
        System.out.println("OK");
        System.out.println("Stopping 1 agent...");
        agent.stop();
        System.out.println("Checking agent stopped...");
        Assert.assertTrue((boolean)((IAgentState)agent.getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test_start5Agents() {
        int i;
        IAgentRunner runner = this.initAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents...");
        List agents = runner.startAgents(NUM_AGENTS);
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Checking agents' log levels...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((LogCategory)((AbstractAgent)agents.get(i)).getLogger().getCategories().values().iterator().next()).getLevel().equals(Level.ALL));
        }
        System.out.println("OK");
        System.out.println("Stopping " + NUM_AGENTS + " agents...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test_start5AgentsWithDifferentParams() {
        int i;
        IAgentRunner runner = this.initAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents with different parameters...");
        TestAgentParams[] params = new TestAgentParams[NUM_AGENTS];
        for (int i2 = 0; i2 < NUM_AGENTS; ++i2) {
            params[i2] = new TestAgentParams(i2);
        }
        List agents = runner.startAgents((IAgentParameters[])params);
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Checking agents' log levels...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((LogCategory)((AbstractAgent)agents.get(i)).getLogger().getCategories().values().iterator().next()).getLevel().equals(Level.ALL));
        }
        System.out.println("OK");
        System.out.println("Stopping " + NUM_AGENTS + " agents...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test06_AgentRunner_LoggingMethods test = new Test06_AgentRunner_LoggingMethods();
        test.test_start1Agent();
        test.test_start5Agents();
        test.test_start5AgentsWithDifferentParams();
        Test06_AgentRunner_LoggingMethods.tearDown();
    }
}

