/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.factory.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.utils.NullCheck;

public abstract class AbstractGuiceAgentFactory {
    private GuiceAgentModule module;
    private Injector injector;

    public AbstractGuiceAgentFactory() {
    }

    public AbstractGuiceAgentFactory(GuiceAgentModule module) {
        this.module = module;
    }

    protected GuiceAgentModule getAgentModule() {
        return this.module;
    }

    protected synchronized void setAgentModule(GuiceAgentModule module) {
        if (module == this.module) {
            return;
        }
        this.module = module;
        this.injector = null;
    }

    protected synchronized Injector getInjector() {
        if (this.injector == null) {
            GuiceAgentModule module = this.getAgentModule();
            NullCheck.check((Object)((Object)module), (String)"getAgentModule()");
            this.injector = Guice.createInjector((Module[])new Module[]{module});
            NullCheck.check((Object)this.injector, (String)"Guice.createInjector(getAgentModule())");
        }
        return this.injector;
    }
}

