/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldEventWrapper;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.impl.AbstractWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;

@AgentScoped
public class EventDrivenWorldView
extends AbstractWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "EventDrivenWorldViewDependency";
    protected boolean receiveEventProcessing = false;
    protected Queue<IWorldChangeEvent> notifyEventsList = new LinkedList<IWorldChangeEvent>();

    @Inject
    public EventDrivenWorldView(@Named(value="EventDrivenWorldViewDependency") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    @Override
    protected void raiseEvent(IWorldEvent event) {
        try {
            super.raiseEvent(event);
        }
        catch (Exception e) {
            this.controller.fatalError("Exception raising event " + event, e);
            this.kill();
        }
    }

    protected void innerNotify(IWorldChangeEvent event) {
        NullCheck.check((Object)event, (String)"event");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("processing " + event);
        }
        if (event instanceof IWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent((IWorldObjectUpdatedEvent)event);
        } else if (event instanceof IWorldEventWrapper) {
            this.raiseEvent(((IWorldEventWrapper)event).getWorldEvent());
        } else if (event instanceof IWorldEvent) {
            this.raiseEvent((IWorldEvent)((Object)event));
        } else {
            throw new PogamutException("Unsupported event type received (" + event.getClass() + ").", (Object)this);
        }
    }

    protected void objectUpdatedEvent(IWorldObjectUpdatedEvent updateEvent) {
        IWorldObject obj = this.get(updateEvent.getId());
        IWorldObjectUpdateResult<IWorldObject> updateResult = updateEvent.update(obj);
        switch (updateResult.getResult()) {
            case CREATED: {
                this.objectCreated(updateResult.getObject());
                return;
            }
            case UPDATED: {
                if (updateResult.getObject() != obj) {
                    throw new PogamutException("Update event " + updateEvent + " does not returned the same instance of the object (result UPDATED).", (Object)this);
                }
                this.objectUpdated(obj);
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                this.objectDestroyed(obj);
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    protected void objectCreated(IWorldObject obj) {
        this.addWorldObject(obj);
        this.raiseEvent(new WorldObjectFirstEncounteredEvent<IWorldObject>(obj, obj.getSimTime()));
        this.objectUpdated(obj);
    }

    protected void objectUpdated(IWorldObject obj) {
        this.raiseEvent(new WorldObjectUpdatedEvent<IWorldObject>(obj, obj.getSimTime()));
    }

    protected void objectDestroyed(IWorldObject obj) {
        this.removeWorldObject(obj);
        this.raiseEvent(new WorldObjectDestroyedEvent<IWorldObject>(obj, obj.getSimTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notify(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        if (this.isPaused()) {
            throw new ComponentPausedException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (this.receiveEventProcessing) {
            this.notifyEventsList.add(event);
            return;
        }
        this.receiveEventProcessing = true;
        try {
            this.innerNotify(event);
            while (this.notifyEventsList.size() != 0) {
                this.innerNotify(this.notifyEventsList.poll());
            }
        }
        finally {
            this.receiveEventProcessing = false;
        }
    }

    @Override
    public synchronized void notifyImmediately(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        this.innerNotify(event);
    }
}

