/*
 * Decompiled with CFR 0.152.
 */
package utils;

import decisionMakingSystem.GlobalParameters;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public final class TimeUtils {
    private static String[] days = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};

    public static int counterToDays(int counter) {
        return counter / GlobalParameters.LENGHT_OF_A_DAY + 1;
    }

    public static double counterToHours(int counter) {
        double temp = (double)(counter % GlobalParameters.LENGHT_OF_A_DAY) / ((double)GlobalParameters.LENGHT_OF_A_DAY / 24.0);
        return temp;
    }

    public static boolean isHour(int counter) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        return tmp % TimeUtils.minutesToTicksOfLogic(60.0) == 0;
    }

    public static boolean isHour(int counter, int i) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        return tmp % TimeUtils.minutesToTicksOfLogic(60.0) == 0 && tmp / TimeUtils.minutesToTicksOfLogic(60.0) == i;
    }

    public static boolean isDay(int counter, int i) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        return tmp == 0 && counter / GlobalParameters.LENGHT_OF_A_DAY == i;
    }

    public static int minutesToTicksOfLogic(double minutes) {
        long result = Math.round((double)GlobalParameters.LENGHT_OF_A_DAY / 1440.0 * minutes);
        return (int)result;
    }

    public static String counterToDate(int counter) {
        String result = "";
        int day = TimeUtils.counterToDays(counter) - 1;
        int hour = (int)TimeUtils.counterToHours(counter);
        int minutes = counter % TimeUtils.hourInTicksOfLogic() * 60 / TimeUtils.hourInTicksOfLogic();
        result = days[day % 7] + ", " + (hour < 10 ? "0" : "") + hour + ":";
        result = result + (minutes < 10 ? "0" : "") + minutes + ", day " + day + ".";
        return result;
    }

    public static int hourInTicksOfLogic() {
        return (int)Math.round((double)GlobalParameters.LENGHT_OF_A_DAY / 24.0);
    }

    public static String counterToTime(int counter) {
        int day = counter / GlobalParameters.LENGHT_OF_A_DAY;
        int hour = (int)TimeUtils.counterToHours(counter);
        int minutes = counter % GlobalParameters.LENGHT_OF_A_DAY % TimeUtils.minutesToTicksOfLogic(60.0);
        minutes = TimeUtils.counterToMinutes(minutes);
        return day + "d " + hour + "h " + minutes + "m.";
    }

    private static int counterToMinutes(int counter) {
        return counter / (GlobalParameters.LENGHT_OF_A_DAY / 1440);
    }

    public static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    public static long getTimeInMilis() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }
}

