/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import bot.Bot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import decisionMakingSystem.Action;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.BasicIntentionLoader;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.Intention;
import decisionMakingSystem.ItemCathegory;
import decisionMakingSystem.MessageType;
import decisionMakingSystem.PerceptiveField;
import decisionMakingSystem.Tuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import utils.HashMapWrapper;
import utils.MyHashMapEntry;
import utils.TimeUtils;

public class ThingsManager {
    private Bot agent = null;
    private Logger log = null;
    public final HashMap<Long, EItem> visibleItems;
    public HashMap<UnrealId, Long> idTable;
    private HashMap<String, EItem> itemParameters = null;
    private PerceptiveField percField = null;
    private DecisionModuleImpl decisionModule = null;
    private ArrayList<Action> possibleActions = null;
    private boolean night = true;
    private boolean ready = false;
    PlayerListener playerListener;
    NavPointListener navPointListener;
    ItemListener itemListener;
    BegListener begListener;

    public ThingsManager(Bot agent, Logger log, PerceptiveField field, String directory, DecisionModuleImpl decisionModule) {
        this.agent = agent;
        this.log = log;
        this.percField = field;
        this.visibleItems = new HashMap();
        this.idTable = new HashMap();
        this.playerListener = new PlayerListener((IWorldView)agent.getWorldView());
        this.navPointListener = new NavPointListener((IWorldView)agent.getWorldView());
        this.itemListener = new ItemListener((IWorldView)agent.getWorldView());
        this.itemParameters = ThingsManager.loadItemParameters(directory + agent.mapMarkings);
        log.config("Known types of items: " + this.itemParameters.keySet());
        this.decisionModule = decisionModule;
        this.possibleActions = new ArrayList();
        for (Intention intention : decisionModule.allIntentions) {
            this.possibleActions.addAll(BasicIntentionLoader.getActionsWithAtomicActions(intention));
        }
        int index = 0;
        while (index < this.possibleActions.size()) {
            if (this.possibleActions.get((int)index).satisfyingItems != null && this.possibleActions.get((int)index).satisfyingItems.isEmpty()) {
                this.possibleActions.remove(index);
                continue;
            }
            ++index;
        }
    }

    public boolean isNight() {
        return this.night;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromPerception(long id, EItem newItem) {
        HashMap<Long, EItem> hashMap = this.visibleItems;
        synchronized (hashMap) {
            if (!this.visibleItems.containsKey(id)) {
                return;
            }
            this.visibleItems.remove(id);
        }
    }

    public void everyRoundUpdate(int counter) {
    }

    public EItem processItem(Item item) {
        EItem eItem = null;
        if (this.itemParameters.containsKey(item.getType().getName())) {
            eItem = this.itemParameters.get(item.getType().getName());
            eItem.item = item;
            eItem.setLocation(item.getLocation());
            Long longId = this.idTable.get(item.getId());
            if (longId == null) {
                Long newId = (long)this.idTable.size() + 1L;
                this.idTable.put(item.getId(), newId);
                longId = newId;
            }
            eItem.setId(longId);
            eItem.type = MessageType.ITEM;
            eItem.cathegory = ItemCathegory.PICKABLE;
        } else {
            this.log.severe("Unknown item! class: " + item.getType().getName());
        }
        return eItem;
    }

    public EItem processItem(ItemPickedUp item) {
        EItem eItem = null;
        String itemClass = item.getType().getName();
        if (this.itemParameters.containsKey(itemClass)) {
            eItem = this.itemParameters.get(itemClass);
            eItem.item = item;
            eItem.setLocation(item.getLocation());
            Long longId = this.idTable.get(item.getId());
            if (longId == null) {
                Long newId = (long)this.idTable.size() + 1L;
                this.idTable.put(item.getId(), newId);
                longId = newId;
            }
            eItem.setId(longId);
            eItem.type = MessageType.ADD_ITEM;
            eItem.cathegory = ItemCathegory.INVENTORY;
        } else {
            this.log.warning("Unknown item! class: " + itemClass);
        }
        return eItem;
    }

    public EItem processItem(NavPoint item) {
        EItem eItem = null;
        if (this.itemParameters.containsKey(item.getId().getStringId())) {
            eItem = this.itemParameters.get(item.getId().getStringId());
            eItem.item = item;
            eItem.setLocation(item.getLocation());
            Long longId = this.idTable.get(item.getId());
            if (longId == null) {
                Long newId = (long)this.idTable.size() + 1L;
                this.idTable.put(item.getId(), newId);
                longId = newId;
            }
            eItem.setId(longId);
            eItem.type = MessageType.NAV_POINT;
            eItem.cathegory = ItemCathegory.PLACE;
        }
        return eItem;
    }

    public EItem processItem(Player item) {
        EItem eItem = null;
        if (item.getId().getStringId().contains("RemoteBot19")) {
            if (this.itemParameters.containsKey("Prey")) {
                eItem = this.itemParameters.get("Prey");
                eItem.item = item;
                eItem.setLocation(item.getLocation());
                Long longId = this.idTable.get(item.getId());
                if (longId == null) {
                    Long newId = (long)this.idTable.size() + 1L;
                    this.idTable.put(item.getId(), newId);
                    longId = newId;
                }
                eItem.setId(longId);
                eItem.type = MessageType.PLAYER;
                eItem.cathegory = ItemCathegory.PLAYER;
            }
        } else if (this.itemParameters.containsKey("Player")) {
            eItem = this.itemParameters.get("Player");
            eItem.item = item;
            eItem.setLocation(item.getLocation());
            Long longId = this.idTable.get(item.getId());
            if (longId == null) {
                Long newId = (long)this.idTable.size() + 1L;
                this.idTable.put(item.getId(), newId);
                longId = newId;
            }
            eItem.setId(longId);
            eItem.type = MessageType.PLAYER;
            eItem.cathegory = ItemCathegory.PLAYER;
        } else {
            this.log.warning("Unknown item! class: Player");
        }
        return eItem;
    }

    private static HashMap<String, EItem> loadItemParameters(String fileName) {
        HashMapWrapper wrapper = null;
        File file = new File(fileName);
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HashMapWrapper.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (HashMapWrapper)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading things parameters! " + e);
        }
        HashMap<String, EItem> result = new HashMap<String, EItem>();
        for (MyHashMapEntry entry : wrapper.entry) {
            result.put(entry.key, entry.value);
        }
        return result;
    }

    public static void makeFirstEntry(String fileName) {
        HashMap<String, EItem> hashMap = new HashMap<String, EItem>();
        EItem item = new EItem();
        ArrayList<Affordance> affos = new ArrayList<Affordance>();
        affos.add(new Affordance(AffordanceType.TO_EAT));
        affos.add(new Affordance(AffordanceType.TO_WASH));
        item.setAffordances(affos);
        item.setFadeout(10);
        item.setBasicAttractivity(15);
        item.name = "Apple";
        item.classOfItem = "XWeapons.RocketLauncherPickup";
        EItem item2 = new EItem();
        affos.clear();
        affos.add(new Affordance(AffordanceType.TO_CLEAN));
        item2.setAffordances(affos);
        item2.setFadeout(10);
        item2.setBasicAttractivity(25);
        item2.name = "Hunting clothes";
        item2.classOfItem = "XWeapons.SniperRiflePickup";
        hashMap.put(item.classOfItem, item);
        hashMap.put(item2.classOfItem, item2);
        HashMapWrapper wrapper = new HashMapWrapper(hashMap);
        try {
            File file = new File(fileName);
            FileOutputStream outputFile = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HashMapWrapper.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)wrapper, (OutputStream)outputFile);
        }
        catch (Exception e) {
            System.err.println("Error in creating things Entry! " + e);
        }
    }

    public static void main(String[] args) {
        HashMap<String, EItem> items = null;
        ThingsManager.makeFirstEntry("itemsParametersTest.xml");
        items = ThingsManager.loadItemParameters("itemParametersTest.xml");
        System.out.println(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int probability(EItem newItem) {
        int coefficient;
        String logReport = "Probability count for: " + newItem.name + "\n";
        int probability = 0;
        int s1 = 0;
        int s2 = 0;
        boolean print = false;
        HashMap<Long, EItem> hashMap = this.visibleItems;
        synchronized (hashMap) {
            for (EItem item : this.visibleItems.values()) {
                coefficient = 1;
                for (Action action : this.percField.processArea) {
                    if (this.decisionModule.actualAction != null && this.decisionModule.actualAction.name.contains("_Search") && action.equals(this.decisionModule.actualAction)) {
                        for (Affordance aff : item.getAffordances()) {
                            if (!this.decisionModule.actualAction.satisfyingItems.keySet().contains((Object)aff.type)) continue;
                            coefficient += 4;
                        }
                        continue;
                    }
                    for (Affordance aff : item.getAffordances()) {
                        if (!action.enabled || action.satisfyingItems == null || !action.satisfyingItems.keySet().contains((Object)aff.type)) continue;
                        ++coefficient;
                    }
                }
                logReport = logReport + " item:" + item.name + " s1: " + (s1 += item.getBasicAttractivity() - item.decreaseOfAttractivity) + " s2: " + (s2 += (item.getAttractivity() - item.decreaseOfAttractivity) * coefficient) + " \n";
            }
        }
        logReport = logReport + "Sum of S1, S2. S1: " + s1 + " S2: " + s2 + "\n";
        int p1 = (double)s1 < this.decisionModule.agentParameters.effortAttributeCoeficient * 100.0 ? s1 : (int)(this.decisionModule.agentParameters.effortAttributeCoeficient * 100.0);
        int p2 = (double)s2 < this.decisionModule.agentParameters.effortCoeficient * 100.0 ? s2 : (int)(this.decisionModule.agentParameters.effortCoeficient * 100.0);
        logReport = logReport + "P1: " + p1 + " P2 " + p2 + "\n";
        coefficient = 1;
        for (Action action : this.percField.processArea) {
            if (this.decisionModule.actualAction != null && this.decisionModule.actualAction.name.contains("_Search") && action.equals(this.decisionModule.actualAction)) {
                for (Affordance aff : newItem.getAffordances()) {
                    if (!this.decisionModule.actualAction.satisfyingItems.keySet().contains((Object)aff.type)) continue;
                    coefficient += 4;
                }
                continue;
            }
            for (Affordance aff : newItem.getAffordances()) {
                if (!action.enabled || action.satisfyingItems == null || !action.satisfyingItems.keySet().contains((Object)aff.type)) continue;
                ++coefficient;
            }
        }
        int attr1 = newItem.getBasicAttractivity() - newItem.decreaseOfAttractivity;
        int attr2 = newItem.getAttractivity() - newItem.decreaseOfAttractivity;
        logReport = logReport + "Attr1: " + attr1 + " Attr2 " + (attr2 *= coefficient) + "\n";
        probability = attr1 + attr2 == 0 || s1 + s2 == 0 || s1 == 0 || s2 == 0 ? 0 : (attr1 == 0 || s1 == 0 ? attr2 * p2 / s2 : (attr2 == 0 || s2 == 0 ? attr1 * p1 / s1 : attr1 * p1 / s1 + attr2 * p2 / s2));
        probability = (int)Math.round((double)probability * (1.0 - this.percField.stress));
        logReport = logReport + "Probability: " + probability + " stress: " + this.percField.stress;
        if (print) {
            this.log.info(logReport);
        }
        return probability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EItem seeingItem(AffordanceType affordance) {
        HashMap<Long, Tuple> probabilityRange = new HashMap<Long, Tuple>();
        int start = 0;
        int probability = 0;
        Tuple temp = null;
        EItem interestingThing = null;
        EItem source = null;
        HashMap<Long, EItem> hashMap = this.visibleItems;
        synchronized (hashMap) {
            for (EItem item : this.visibleItems.values()) {
                probability = this.probability(item);
                temp = new Tuple(start, start + probability);
                start += probability;
                probabilityRange.put(item.getId(), temp);
            }
            int random = Math.round((float)Math.random() * 100.0f);
            Iterator<EItem> i$ = probabilityRange.keySet().iterator();
            while (i$.hasNext()) {
                long ID = (Long)((Object)i$.next());
                if (random <= ((Tuple)probabilityRange.get((Object)Long.valueOf((long)ID))).a || random >= ((Tuple)probabilityRange.get((Object)Long.valueOf((long)ID))).b) continue;
                interestingThing = this.visibleItems.get(ID);
                break;
            }
        }
        if (interestingThing == null) {
            return null;
        }
        if (affordance != null) {
            for (Affordance aff : interestingThing.getAffordances()) {
                if (aff == null || aff.type == null || !aff.type.equals((Object)affordance)) continue;
                source = interestingThing;
            }
        }
        if (source != null) {
            this.log.fine("Found source for affordance: " + (Object)((Object)affordance) + " | | " + source.getName());
            this.percField.addSource(source);
            return source;
        }
        this.addInterestingItem(interestingThing);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EItem> getItemOfAffordance(AffordanceType aff) {
        ArrayList<EItem> result = new ArrayList<EItem>();
        HashMap<Long, EItem> hashMap = this.visibleItems;
        synchronized (hashMap) {
            for (EItem item : this.visibleItems.values()) {
                if (item == null) continue;
                for (Affordance affordance : item.getAffordances()) {
                    try {
                        if (!affordance.type.equals((Object)aff)) continue;
                        result.add(item);
                    }
                    catch (NullPointerException e) {
                        this.log.severe("Error in getItemOfAffordance! Input: " + (Object)((Object)aff) + ". Item: " + item + " \nAffordance: " + affordance + " Affordance type: " + (Object)((Object)affordance.type));
                    }
                }
            }
        }
        return result;
    }

    void setDMS(DecisionModuleImpl dms) {
        this.decisionModule = dms;
    }

    void setLog(Logger log) {
        this.log = log;
    }

    void setPercField(PerceptiveField perceptiveField) {
        this.percField = perceptiveField;
    }

    private void addInterestingItem(EItem interestingThing) {
        this.percField.addSource(interestingThing);
        Action newAction = null;
        if (this.night) {
            return;
        }
        if (this.decisionModule.counter % TimeUtils.minutesToTicksOfLogic(30.0) == 0) {
            for (Affordance aff : interestingThing.getAffordances()) {
                for (Action act : this.possibleActions) {
                    if (act.satisfyingItems == null || act.satisfyingItems.isEmpty() || !act.satisfyingItems.keySet().contains((Object)aff.type)) continue;
                    newAction = act.cloneBySerialize(this.decisionModule);
                    newAction.intention = null;
                    newAction.activity = interestingThing.getAttractivity();
                    this.percField.addAction(newAction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printVisibleItemsNames() {
        String result = "Visible items: \n";
        HashMap<Long, EItem> hashMap = this.visibleItems;
        synchronized (hashMap) {
            for (long ID : this.visibleItems.keySet()) {
                result = result + "ID:" + ID + " name:" + this.visibleItems.get((Object)Long.valueOf((long)ID)).name + " affordances: ";
                for (Affordance aff : this.visibleItems.get(ID).getAffordances()) {
                    result = result + (Object)((Object)aff.type) + " ";
                }
                result = result + "\n";
            }
        }
        return result;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    private class BegListener
    implements IWorldEventListener<BeginMessage> {
        public BegListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }

        public void notify(BeginMessage event) {
        }
    }

    private class ItemListener
    implements IWorldObjectListener<Item> {
        public ItemListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(IWorldObjectEvent<Item> event) {
            EItem newItem = ThingsManager.this.processItem((Item)event.getObject());
            if (newItem != null) {
                Long longId = ThingsManager.this.idTable.get(((Item)event.getObject()).getId());
                if (longId == null) {
                    Long newId = ((Item)event.getObject()).getId().getLongId();
                    ThingsManager.this.idTable.put(((Item)event.getObject()).getId(), newId);
                    longId = newId;
                }
                if (((Item)event.getObject()).isVisible()) {
                    HashMap<Long, EItem> hashMap = ThingsManager.this.visibleItems;
                    synchronized (hashMap) {
                        ThingsManager.this.visibleItems.put(longId, newItem);
                    }
                } else {
                    ThingsManager.this.removeFromPerception(longId, newItem);
                }
            }
        }
    }

    private class NavPointListener
    implements IWorldObjectListener<NavPoint> {
        public NavPointListener(IWorldView worldView) {
            worldView.addObjectListener(NavPoint.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(IWorldObjectEvent<NavPoint> event) {
            EItem newItem = ThingsManager.this.processItem((NavPoint)event.getObject());
            if (newItem != null) {
                Long longId = ThingsManager.this.idTable.get(((NavPoint)event.getObject()).getId());
                if (longId == null) {
                    Long newId = ((NavPoint)event.getObject()).getId().getLongId();
                    ThingsManager.this.idTable.put(((NavPoint)event.getObject()).getId(), newId);
                    longId = newId;
                }
                if (((NavPoint)event.getObject()).isVisible()) {
                    HashMap<Long, EItem> hashMap = ThingsManager.this.visibleItems;
                    synchronized (hashMap) {
                        ThingsManager.this.visibleItems.put(longId, newItem);
                    }
                } else {
                    ThingsManager.this.removeFromPerception(longId, newItem);
                }
            }
        }
    }

    private class PlayerListener
    implements IWorldObjectListener<Player> {
        public PlayerListener(IWorldView worldView) {
            worldView.addObjectListener(Player.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(IWorldObjectEvent<Player> event) {
            EItem newItem = ThingsManager.this.processItem((Player)event.getObject());
            if (newItem != null) {
                Long longId = ThingsManager.this.idTable.get(((Player)event.getObject()).getId());
                if (longId == null) {
                    Long newId = ((Player)event.getObject()).getId().getLongId();
                    ThingsManager.this.idTable.put(((Player)event.getObject()).getId(), newId);
                    longId = newId;
                }
                if (((Player)event.getObject()).isVisible()) {
                    HashMap<Long, EItem> hashMap = ThingsManager.this.visibleItems;
                    synchronized (hashMap) {
                        ThingsManager.this.visibleItems.put(longId, newItem);
                    }
                } else {
                    ThingsManager.this.removeFromPerception(longId, newItem);
                }
            }
        }
    }
}

