/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import bot.Bot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.AgentParameters;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import java.util.ArrayList;

public class Inventory {
    public ArrayList<ItemPickedUp> collectedItems = null;
    public ArrayList<EItem> collectedEItems = null;
    public Bot agent = null;
    public DecisionModuleImpl module = null;
    public static final int inventorySize = 3;
    private boolean ready = false;
    ItemPickedUpListener itemPickedUpListener;

    public Inventory(Bot agent, DecisionModuleImpl module) {
        this.agent = agent;
        this.module = module;
        this.collectedItems = new ArrayList();
        this.collectedEItems = new ArrayList();
        this.itemPickedUpListener = new ItemPickedUpListener((IWorldView)agent.getWorldView());
    }

    public void midnightUpdate() {
        this.collectedItems = new ArrayList();
        this.collectedEItems = new ArrayList();
    }

    public boolean hasItemOfClass(String pickedType) {
        for (ItemPickedUp item : this.collectedItems) {
            if (!pickedType.contains(item.getType().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean hasItemOfAffordance(AffordanceType affordance) {
        for (EItem item : this.collectedEItems) {
            for (Affordance aff : item.getAffordances()) {
                if (!aff.type.equals((Object)affordance)) continue;
                return true;
            }
        }
        return false;
    }

    public EItem getItemOfAffordance(AffordanceType affordance) {
        for (EItem item : this.collectedEItems) {
            for (Affordance aff : item.getAffordances()) {
                if (aff == null || aff.type == null) {
                    this.agent.getLog().severe("affordance or its type are null! Item:" + item + " Affordance" + (Object)((Object)affordance));
                    continue;
                }
                if (!aff.type.equals((Object)affordance)) continue;
                return item;
            }
        }
        return null;
    }

    public void throwAway(EItem item) {
        if (this.collectedEItems.contains(item)) {
            this.collectedEItems.remove(item);
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    private void addItemToInventory(EItem newEItem) {
        if (this.collectedEItems.size() > AgentParameters.numberOfItemsInInventory) {
            this.throwAwayUnused();
            this.collectedEItems.add(newEItem);
        } else {
            this.collectedEItems.add(newEItem);
        }
        this.module.log.fine("Picked up: " + newEItem.getName() + " | affordances" + newEItem.getAffordances());
    }

    private void throwAwayUnused() {
        int i = 0;
        while (i < this.collectedEItems.size()) {
            EItem item = this.collectedEItems.get(i);
            if (!this.module.perceptiveField.isThingAssignedToAction(item)) {
                this.module.log.config("'Throwing' away " + item.name);
                this.collectedEItems.remove(i);
                continue;
            }
            ++i;
        }
    }

    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public void notify(ItemPickedUp event) {
            EItem newEItem = Inventory.this.module.things.processItem(event);
            if (newEItem != null) {
                Inventory.this.addItemToInventory(newEItem);
                Inventory.this.agent.getLog().fine("Picked up item: " + newEItem.getClass() + (newEItem != null ? " aka: " + newEItem.name : ""));
            }
        }

        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }
    }
}

