/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.ItemCathegory;
import decisionMakingSystem.MessageType;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class EItem
implements Cloneable,
Serializable {
    private ArrayList<Affordance> affordances = null;
    private int attractivity = 0;
    private int basicAttractivity = 0;
    private int fadeout = 0;
    public String classOfItem = null;
    public String name = null;
    public int decreaseOfAttractivity = 0;
    @XmlTransient
    public InfoMessage item = null;
    @XmlTransient
    public MessageType type = null;
    public ItemCathegory cathegory = null;
    private long id;
    private Location location = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public EItem() {
    }

    public EItem(InfoMessage item, MessageType type) {
        this.item = item;
        this.type = type;
    }

    private EItem(ArrayList<Affordance> affordances, int attractivity, int basicAttractivity, int fadeout, String classOfItem, String name, InfoMessage item, MessageType type, ItemCathegory cathegory) {
        this.affordances = (ArrayList)affordances.clone();
        this.attractivity = attractivity;
        this.basicAttractivity = basicAttractivity;
        this.classOfItem = classOfItem;
        this.fadeout = fadeout;
        this.name = name;
        this.item = item;
        this.type = type;
        this.cathegory = cathegory;
    }

    public Object clone() {
        return new EItem(this.affordances, this.attractivity, this.basicAttractivity, this.fadeout, this.classOfItem, this.name, this.item, this.type, this.cathegory);
    }

    public void restartAttractivity() {
        this.attractivity = this.basicAttractivity;
    }

    public void increaseAttractivity() {
        ++this.attractivity;
    }

    public void decreaseAttractivity() {
        this.attractivity = 0;
        this.decreaseOfAttractivity = this.basicAttractivity;
    }

    public ArrayList<Affordance> getAffordances() {
        return this.affordances;
    }

    public void setAffordances(ArrayList<Affordance> affordances) {
        this.affordances = affordances;
    }

    public int getAttractivity() {
        return this.attractivity;
    }

    public void setAttractivity(int attractivity) {
        this.attractivity = attractivity;
    }

    public int getBasicAttractivity() {
        return this.basicAttractivity;
    }

    public void setBasicAttractivity(int attractivity) {
        this.basicAttractivity = attractivity;
    }

    public int getFadeout() {
        return this.fadeout;
    }

    public void setFadeout(int fadeout) {
        this.fadeout = fadeout;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        String temp = this.name + " has: Affordances" + this.affordances + " \n";
        if (this.item != null) {
            temp = temp + this.item + "\n";
        }
        temp = temp + "Cathegory: " + (Object)((Object)this.cathegory) + " basic attractivity: " + this.basicAttractivity;
        temp = temp + " decreased attractivity: " + this.decreaseOfAttractivity + " attractivity: " + this.attractivity;
        return temp;
    }

    public static EItem exampleItem() {
        EItem result = new EItem();
        Affordance aff1 = new Affordance();
        Affordance aff2 = new Affordance();
        aff1.type = AffordanceType.TO_CLEAN;
        result.cathegory = ItemCathegory.PICKABLE;
        result.affordances = new ArrayList();
        result.affordances.add(aff2);
        result.affordances.add(aff1);
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        EItem other = (EItem)o;
        if (other.basicAttractivity != this.basicAttractivity) {
            return false;
        }
        if (!this.affordances.equals(other.affordances)) {
            return false;
        }
        if (!this.item.equals(other.item)) {
            return false;
        }
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return other.cathegory.equals((Object)this.cathegory);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.affordances != null ? this.affordances.hashCode() : 0);
        hash = 89 * hash + this.basicAttractivity;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 89 * hash + (this.item != null ? this.item.hashCode() : 0);
        hash = 89 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 89 * hash + (this.cathegory != null ? this.cathegory.hashCode() : 0);
        return hash;
    }

    public Location getLocation() {
        return this.location;
    }

    void changeAffordaceActivity(int newAttractivity, AffordanceType aff) {
        for (Affordance affordance : this.getAffordances()) {
            if (!affordance.type.equals((Object)aff)) continue;
            affordance.attractivity = newAttractivity;
        }
    }

    public String getName() {
        return this.name;
    }
}

