/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import bot.Bot;
import bot.DMSMemoryVO;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import decisionMakingSystem.ActionStates;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.AgentParameters;
import decisionMakingSystem.BasicIntentionLoader;
import decisionMakingSystem.DMSLogger;
import decisionMakingSystem.DecisionModule;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import decisionMakingSystem.IntentionStates;
import decisionMakingSystem.Inventory;
import decisionMakingSystem.ItemMemory;
import decisionMakingSystem.PerceptiveField;
import decisionMakingSystem.Scheduler;
import decisionMakingSystem.ThingsManager;
import decisionMakingSystem.Want;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import pogamutEndEvent.PogamutEndEventSource;
import pogamutEndEvent.PogamutEndEventType;
import scheduler.ProbabilisticScheduler;
import utils.FileSaveLoadUtils;
import utils.Interval;
import utils.TimeUtils;

public class DecisionModuleImpl
implements DecisionModule,
Serializable {
    public PogamutEndEventSource eventSource = null;
    public transient Logger log;
    public transient Bot agent = null;
    public transient PerceptiveField perceptiveField = null;
    public ArrayList<Intention> basicIntentions = null;
    public ArrayList<Intention> allIntentions = null;
    public ArrayList<Intention> intentionArea = null;
    public transient ThingsManager things = null;
    public int counter = 0;
    public transient Inventory inventory = null;
    public Intention actualIntention = null;
    public Action actualAction = null;
    Scheduler scheduler = null;
    public AgentParameters agentParameters = null;
    public HashMap<String, Intention> nameToIntention = null;
    private int testCaseCounter = 0;
    private AtomicAction actualAtomicAction = null;
    private AtomicAction oldAtomicAction = null;
    private transient DMSLogger dmsLogger = null;
    public ItemMemory memory;
    private Intention searchIntention = null;

    public DecisionModuleImpl() {
    }

    public DecisionModuleImpl(ItemMemory itemMemory) {
        this.memory = itemMemory;
    }

    public void changeLifestyle(String directory, String planningFilename, int i) {
        this.scheduler.changeLifestyle(directory, planningFilename, i);
        this.scheduler.scheduleNewDay(this.counter);
        this.log.config("New lifestyle prepared");
    }

    public void prepareLogic(Bot agent, String directory, String planningFilename) {
        this.log = agent.getLog();
        this.agent = agent;
        this.perceptiveField = new PerceptiveField((Logger)agent.getLog(), this.things, this);
        this.allIntentions = BasicIntentionLoader.importIntentionForest(directory, this);
        this.intentionArea = new ArrayList();
        this.perceptiveField.allThings = this.things = new ThingsManager(agent, this.log, this.perceptiveField, directory, this);
        this.inventory = new Inventory(agent, this);
        this.scheduler = new ProbabilisticScheduler(this.allIntentions, this.log, directory, planningFilename);
        this.nameToIntention = new HashMap();
        for (Intention intention : this.allIntentions) {
            this.nameToIntention.put(intention.getName(), intention);
        }
        this.agentParameters = new AgentParameters();
        GlobalParameters.getInstance();
        this.things.setReady(true);
        this.inventory.setReady(true);
        this.eventSource = new PogamutEndEventSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sensing() {
        ++this.counter;
        HashMap<Long, EItem> hashMap = this.things.visibleItems;
        synchronized (hashMap) {
            if (!this.things.visibleItems.isEmpty() && this.counter % 20 == 0) {
                for (EItem item : this.things.visibleItems.values()) {
                    this.memory.addItemToMemory(item, 0, 1);
                }
            }
        }
    }

    public void setGMT(double gmtTime) {
        GMTTime.setGMT(gmtTime, this);
    }

    protected Action chooseAction(Intention intention) {
        Action result = intention.chooseAction();
        if (result == null) {
            intention.setRealized(IntentionStates.FAILED);
            if (!intention.getName().contains("Want")) {
                String toLog = "";
                toLog = toLog + TimeUtils.counterToDate(this.counter + TimeUtils.minutesToTicksOfLogic(this.getGMTTime() * 60.0)) + " ";
                toLog = toLog + intention.getName() + " failed.\r\n";
                this.dmsLogger.writeAMessage(toLog);
            }
            return null;
        }
        this.perceptiveField.addAction(result);
        return this.prepareAction(result);
    }

    protected Action prepareAction(Action action) {
        Intention temp = null;
        boolean ready = true;
        if (action.getCurrentIntention() != null) {
            temp = this.chooseIntention(action);
            return temp.getChosenAction();
        }
        if (action.satisfyingItems != null && !action.name.contains("_Search")) {
            for (AffordanceType aff : action.satisfyingItems.keySet()) {
                if (this.perceptiveField.isAffordanceSatisfied(aff, action)) continue;
                ready = false;
                Want want = new Want(aff, action, this);
                if (action.intentions == null) {
                    action.intentions = new ArrayList();
                }
                action.intentions.add(want);
            }
        }
        if (!ready) {
            temp = this.chooseIntention(action);
            return temp.getChosenAction();
        }
        if (action.getCurrentAtomicAction() != null) {
            action.state = ActionStates.EXECUTE;
            return action;
        }
        if (!action.state.equals((Object)ActionStates.FAILED)) {
            action.state = ActionStates.TERMINATED;
        }
        return action;
    }

    protected Intention chooseIntention(Action action) {
        Intention intention = action.chooseIntention();
        if (intention != null) {
            Action temp = null;
            this.addIntention(intention);
            temp = this.chooseAction(intention);
            return temp.intention;
        }
        return null;
    }

    protected void actionFailed(Action action) {
        Action newAction;
        this.eventSource.fireEvent(PogamutEndEventType.ACTION_SUCCEEDED, action);
        this.removeActionAndDescendantIntentions(action);
        if (action.intention == null) {
            return;
        }
        action.intention.setChosenAction(null);
        if (!action.intention.getName().contains("Want")) {
            action.intention.getNotTriedActions().remove(action);
        }
        if ((newAction = this.chooseAction(action.intention)) == null) {
            action.intention.setRealized(IntentionStates.FAILED);
            this.intentionFailed(action.intention);
        }
    }

    protected void actionSucceeded(Action action) {
        this.eventSource.fireEvent(PogamutEndEventType.ACTION_SUCCEEDED, action);
        this.removeActionAndDescendantIntentions(action);
        this.throwAwayUsedThings(action);
        if (action.intention == null) {
            return;
        }
        action.intention.setRealized(IntentionStates.YES);
        this.intentionSucceeded(action.intention);
    }

    protected void intentionFailed(Intention intention) {
        this.eventSource.fireEvent(PogamutEndEventType.INTENTION_FAILED, intention);
        this.removeIntention(intention);
        if (intention.getAncestorAction() == null) {
            this.dropOut(intention);
        } else {
            intention.getAncestorAction().state = ActionStates.FAILED;
            this.actionFailed(intention.getAncestorAction());
        }
    }

    protected void intentionSucceeded(Intention intention) {
        this.eventSource.fireEvent(PogamutEndEventType.INTENTION_SUCCEEDED, intention);
        this.removeIntention(intention);
        if (intention.getAncestorAction() == null) {
            this.dropOut(intention);
        } else {
            ++intention.getAncestorAction().unfullfiledIntentionsIndex;
            Intention newIntention = this.chooseIntention(intention.getAncestorAction());
            if (newIntention == null && intention.getAncestorAction().getCurrentAtomicAction() == null) {
                this.actionSucceeded(intention.getAncestorAction());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMSMemoryVO doReasoning(int myCounter) {
        this.everyRoundUpdate(myCounter);
        this.counter = myCounter;
        this.things.seeingItem(null);
        this.perceptiveField.updateStress();
        this.perceptiveField.updateActivities(this.counter);
        this.perceptiveField.updateFadeout();
        this.updateIntentionFadeout();
        this.actualIntention = this.checkRootIntentions(this.counter);
        AtomicAction tmpAtomicAction = null;
        this.oldAtomicAction = null;
        if (this.actualIntention != null) {
            this.addIntention(this.actualIntention);
            this.actualAction = this.chooseAction(this.actualIntention);
            if (!this.actualAction.intention.equals(this.actualIntention)) {
                this.actualIntention = this.actualAction.intention;
            }
        }
        this.actualAction = this.perceptiveField.chooseAction(this.counter);
        if (this.actualAction != null && this.actualAction.intention == null) {
            this.actualAction = this.prepareAction(this.actualAction);
        }
        DecisionModuleImpl decisionModuleImpl = this;
        synchronized (decisionModuleImpl) {
            this.log.finest("Counter: " + this.counter + "\n INTENTION AREA: " + this.intentionArea + " \n\n" + "PROCESS AREA: " + this.perceptiveField.processArea + " \n\n" + this.perceptiveField.printPerceivedItems() + "\n\n GMT: " + GMTTime.getGMT());
        }
        if (this.counter % TimeUtils.minutesToTicksOfLogic(30.0) == 0) {
            this.log.finest("Basic intentions: " + this.basicIntentions);
        }
        if (this.actualAction == null) {
            if (this.scheduler.getClass().equals(ProbabilisticScheduler.class)) {
                this.basicIntentions = ((ProbabilisticScheduler)this.scheduler).scheduleNewIntention(this.counter);
            } else {
                this.agent.getAct().act((CommandMessage)new Configuration().setName("Bored to death!"));
            }
            return new DMSMemoryVO(this);
        }
        this.perceptiveField.increaseAttractivityToAllSources(this.actualAction);
        tmpAtomicAction = this.actualAtomicAction == null ? (this.actualAtomicAction = this.actualAction.executeAtomicActions(this.log)) : this.actualAction.executeAtomicActions(this.log);
        if (this.actualAtomicAction != null && !this.actualAtomicAction.equals(tmpAtomicAction)) {
            this.oldAtomicAction = this.actualAtomicAction;
            this.actualAtomicAction = tmpAtomicAction;
        }
        if (this.actualAction == null || this.actualAction.state == null) {
            return new DMSMemoryVO(this);
        }
        if (this.actualAction.state.equals((Object)ActionStates.FAILED)) {
            this.actionFailed(this.actualAction);
        }
        if (this.actualAction.state.equals((Object)ActionStates.TERMINATED)) {
            this.actionSucceeded(this.actualAction);
        }
        if (this.actualAction.intention != null) {
            this.actualAction.intention.rootIntention().increaseDuration();
        }
        return new DMSMemoryVO(this);
    }

    void replan(double GMT) {
        int newStart = this.counter - this.counter % GlobalParameters.LENGHT_OF_A_DAY;
        newStart -= TimeUtils.minutesToTicksOfLogic(GMT * 60.0);
        if (GMT < 0.0 && TimeUtils.counterToHours(this.counter) < -GMT) {
            newStart -= GlobalParameters.LENGHT_OF_A_DAY;
        }
        this.basicIntentions = this.scheduler.scheduleNewDay(newStart);
        this.log.config("Replanning the day! Time zone changed:" + GMT + " \nIn the ticks of logic: " + TimeUtils.minutesToTicksOfLogic(-GMT * 60.0) + " \nNew start: " + newStart + " counter: " + this.counter);
        this.intentionArea.clear();
        this.perceptiveField.clearProcessArea();
        this.log.config("New plan: " + this.basicIntentions);
    }

    private void addIntention(Intention intention) {
        if (!this.intentionArea.contains(intention)) {
            if (intention.getAncestorAction() != null && intention.getAncestorAction().intention != null) {
                intention.getAncestorAction().intention.setEnabled(false);
            }
            this.intentionArea.add(intention);
            intention.setFadeout(GlobalParameters.FADEOUT_FOR_INTENTIONS);
        }
    }

    private Intention checkRootIntentions(int timeCounter) {
        Intention maxIntention = null;
        int maxActivity = 0;
        int index = 0;
        Intention temp = null;
        boolean fromBasicIntentions = false;
        while (index < this.intentionArea.size()) {
            temp = this.intentionArea.get(index);
            if (temp.getRealized() == IntentionStates.FAILED || temp.getRealized() == IntentionStates.YES) {
                this.removeIntention(temp);
                continue;
            }
            if (temp.isEnabled() && temp.getActivity() > maxActivity) {
                maxIntention = temp;
                maxActivity = temp.getActivity();
            }
            ++index;
        }
        for (Intention i : this.basicIntentions) {
            i.updateActivity(timeCounter);
            if (this.intentionArea.contains(i) && !this.intentionArea.get(this.intentionArea.indexOf(i)).isEnabled() && this.intentionArea.get(this.intentionArea.indexOf(i)).getActivity() == i.getActivity() || i.getActivity() <= maxActivity) continue;
            fromBasicIntentions = true;
            maxIntention = i;
            maxActivity = i.getActivity();
        }
        if (fromBasicIntentions) {
            this.log.info(TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(this.counter)) + " Max intention choosen from basicIntentions: " + maxIntention.getName());
            return maxIntention.cloneBySerialize(this.agent, this);
        }
        this.eventSource.fireEvent(PogamutEndEventType.INTENTION_AREA, this.intentionArea);
        return maxIntention;
    }

    protected void removeActionAndDescendantIntentions(Action actualAction) {
        this.log.fine("removing action: " + actualAction.name + " state: " + (Object)((Object)actualAction.state));
        this.perceptiveField.removeAction(actualAction);
        if (actualAction.intention != null) {
            actualAction.intention.setEnabled(true);
            if (actualAction.intention.getAncestorAction() != null) {
                actualAction.intention.getAncestorAction().enabled = true;
            }
        }
        int index = 0;
        Intention temp = null;
        while (index < this.intentionArea.size()) {
            temp = this.intentionArea.get(index);
            if (temp.getAncestorAction() != null && temp.getAncestorAction().equals(actualAction)) {
                this.log.fine("removing " + this.intentionArea.get(index));
                this.perceptiveField.removeActionsOfIntention(temp);
                this.intentionArea.remove(index);
                continue;
            }
            ++index;
        }
    }

    protected void removeIntention(Intention intention) {
        if (intention.getAncestorAction() != null) {
            intention.getAncestorAction().enabled = true;
            if (intention.getAncestorAction().intention != null) {
                intention.getAncestorAction().intention.setEnabled(true);
            }
        }
        this.intentionArea.remove(intention);
        this.perceptiveField.removeActionsOfIntention(intention);
    }

    private void dropOut(Intention actualIntention) {
        for (Intention i : this.basicIntentions) {
            if (!i.getName().equals(actualIntention.getName())) continue;
            i.dropOut(this.counter);
            break;
        }
    }

    private void updateIntentionFadeout() {
        int index = 0;
        Intention intention = null;
        while (index < this.intentionArea.size()) {
            intention = this.intentionArea.get(index);
            if (intention.isEnabled() && !intention.equals(this.actualIntention)) {
                intention.decreaseFadeout();
            }
            if (intention.getFadeout() < 0) {
                this.removeIntention(intention);
                continue;
            }
            ++index;
        }
    }

    private void throwAwayUsedThings(Action action) {
        if (action.satisfyingItems == null) {
            return;
        }
        for (EItem item : action.satisfyingItems.values()) {
            this.inventory.throwAway(item);
        }
    }

    @Override
    public void addIntention(String name, Interval actInterval) {
        boolean addInterval = true;
        boolean addIntention = true;
        for (Intention intention : this.basicIntentions) {
            if (!intention.getName().equals(name)) continue;
            addIntention = false;
            for (Interval interval : intention.getActivationIntervals()) {
                if (!interval.isInInterval(actInterval.getLeftSide())) continue;
                addInterval = false;
                return;
            }
            if (!addInterval) continue;
            intention.getActivationIntervals().add(actInterval);
            this.log.config("intention: " + name + ". New activation interval added: " + actInterval + " \n intention: " + intention);
            return;
        }
        if (!addIntention) {
            return;
        }
        if (!this.nameToIntention.containsKey(name)) {
            this.log.warning("About to add unknown intention " + name);
            return;
        }
        Intention intentionToAdd = this.nameToIntention.get(name).cloneBySerialize(this.agent, this);
        ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
        activationIntervals.add(actInterval);
        intentionToAdd.setActivationIntervals(activationIntervals);
        this.basicIntentions.add(intentionToAdd);
        this.log.config("intention: " + name + " added. Activation interval: " + actInterval + " \n Intention: " + intentionToAdd);
    }

    public DMSMemoryVO test() {
        switch (this.testCaseCounter) {
            default: 
        }
        return this.doReasoning(this.counter);
    }

    private boolean testCaseItemAttractivity() {
        this.doReasoning(this.counter);
        String result = "";
        for (EItem item : this.things.visibleItems.values()) {
            result = result + "Item: " + item.name + " attractivity: " + item.getAttractivity();
            result = result + " basic attractivity: " + item.getBasicAttractivity();
            result = result + " decrease: " + item.decreaseOfAttractivity + " fadeout: " + item.getFadeout() + "\n";
        }
        this.log.config(result);
        this.log.config("Perceptive field: " + this.perceptiveField.printPerceivedItems());
        return this.counter % 1000 == 999;
    }

    private boolean testCaseStressAndConcentration() {
        this.doReasoning(this.counter);
        return this.counter % 1000 == 999;
    }

    public void doReasoningItemScenario() {
        if (this.counter == 0) {
            this.searchIntention = new Intention();
            ArrayList<Action> actions = new ArrayList<Action>();
            Action action = new Action();
            action.satisfyingItems.put(AffordanceType._TO_STUDY_ON, null);
            action.satisfyingItems.put(AffordanceType._TO_PLAY_ON, null);
            action.satisfyingItems.put(AffordanceType._TO_WASH_WITH, null);
            action.satisfyingItems.put(AffordanceType._TO_STUDY_AT, null);
            action.satisfyingItems.put(AffordanceType.TO_READ, null);
            action.satisfyingItems.put(AffordanceType.TO_RUN_IN, null);
            action.satisfyingItems.put(AffordanceType.TO_EAT, null);
            actions.add(action);
            action.timeLimit = 300;
            action.intention = this.searchIntention;
            action.name = "Test Search Action";
            this.searchIntention.setName("Search INTENTION");
            this.searchIntention.setActions(actions);
            ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
            activationIntervals.add(new Interval(this.counter, this.counter + 100, 80));
            this.searchIntention.setActivationIntervals(activationIntervals);
            this.basicIntentions.add(this.searchIntention);
        }
        if (this.actualIntention != null && this.actualIntention.getName().equals("Search INTENTION") && (this.actualIntention.getRealized().equals((Object)IntentionStates.FAILED) || this.actualIntention.getRealized().equals((Object)IntentionStates.YES))) {
            ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
            activationIntervals.add(new Interval(this.counter, this.counter + 100, 80));
            this.searchIntention.setActivationIntervals(activationIntervals);
        }
        this.doReasoning(this.counter);
    }

    private void everyRoundUpdate(int myCounter) {
        this.counter = myCounter;
        if (GMTTime.isMidnight(this.counter) || this.basicIntentions == null) {
            this.basicIntentions = this.scheduler.scheduleNewDay(this.counter);
            this.log.warning("Plan of " + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(this.counter)) + ": " + this.basicIntentions);
            this.intentionArea.clear();
            this.perceptiveField.clearProcessArea();
        }
        this.things.everyRoundUpdate(this.counter);
    }

    @Override
    public Action getActualAction() {
        return this.actualAction;
    }

    @Override
    public Intention getActualIntention() {
        return this.actualIntention;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public AtomicAction getActualAtomicAction() {
        return this.actualAtomicAction;
    }

    @Override
    public AtomicAction getOldAtomicAction() {
        return this.oldAtomicAction;
    }

    @Override
    public double getGMTTime() {
        return GMTTime.getGMT();
    }

    public void saveToFile(String filename) {
        FileSaveLoadUtils.saveObject(this, filename, this.log);
    }

    public static DecisionModuleImpl loadFromFile(String filename, Logger log, Bot agent, String directory) {
        Object dms1 = FileSaveLoadUtils.loadObject(filename, log);
        if (!(dms1 instanceof DecisionModuleImpl)) {
            throw new IllegalStateException("The choosen file does not contain object of class DecisionModuleImpl");
        }
        DecisionModuleImpl dms = (DecisionModuleImpl)dms1;
        dms.inventory = new Inventory(agent, dms);
        dms.perceptiveField = new PerceptiveField(log, null, dms);
        dms.things = new ThingsManager(agent, log, dms.perceptiveField, directory, dms);
        dms.perceptiveField.setThings(dms.things);
        dms.memory = agent.itemMemory;
        dms.setLoggerAfterLoad(log);
        dms.setAgentAfterLoad(agent);
        dms.things.setReady(true);
        dms.inventory.setReady(true);
        dms.setToNullAllNeeded();
        dms.replan(dms.getGMTTime());
        return dms;
    }

    private void setToNullAllNeeded() {
        this.actualAction = null;
        this.actualIntention = null;
        this.actualIntention = null;
        this.oldAtomicAction = null;
        this.intentionArea.clear();
        this.perceptiveField.processArea.clear();
        this.perceptiveField.perceivedItems.clear();
        this.things.visibleItems.clear();
    }

    private void setLoggerAfterLoad(Logger log) {
        this.log = log;
        this.scheduler.setLog(log);
    }

    private void setAgentAfterLoad(Bot agent) {
        this.agent = agent;
    }

    public void setDMSLogger(DMSLogger logger) {
        this.dmsLogger = logger;
    }
}

