/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import bot.DMSMemoryVO;
import bot.FileLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.DateUtils;
import utils.TimeUtils;

public class DMSLogger
implements FileLog {
    private AtomicAction lastAtomicAction = null;
    private File file = null;
    private Logger userLog = null;
    private FileOutputStream outputFile = null;
    private boolean ready = false;

    public DMSLogger(Logger log, String filename) {
        this.file = new File(filename);
        this.userLog = log;
        try {
            if (this.file.exists()) {
                this.outputFile = new FileOutputStream(this.file, true);
            } else {
                boolean createNewFile = this.file.createNewFile();
                if (!createNewFile) {
                    log.severe("File not initiated." + this.file.getAbsolutePath());
                }
                this.outputFile = new FileOutputStream(this.file);
            }
        }
        catch (IOException e) {
            log.severe("IO Exception when creating DMSLogger: " + e);
        }
        this.ready = true;
        this.userLog.info("File Logger initiated." + filename);
    }

    private String getFormattedMessage(DMSMemoryVO memVO) {
        String toLog = "";
        AtomicAction action = memVO.getOldAtomicAction();
        if (action != null && !action.type.name().contains("SEARCH_")) {
            toLog = toLog + TimeUtils.counterToDate(memVO.getThoughtTimeTicks()) + " " + (Object)((Object)action.type);
            toLog = action.succeeded() ? toLog + " succeeded." : (action.failed() ? toLog + " failed." : toLog + " interrupted.");
            toLog = toLog + "\r\n";
        }
        return toLog;
    }

    public void update(DMSMemoryVO memoryVO) {
        String toLog = this.getFormattedMessage(memoryVO);
        if (!toLog.equals("")) {
            try {
                this.outputFile.write(toLog.getBytes());
                toLog = "";
            }
            catch (IOException ex) {
                Logger.getLogger(DMSLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (memoryVO.getActualAtomicAction() != null && !memoryVO.getActualAtomicAction().equals(this.lastAtomicAction) && !memoryVO.getActualAtomicAction().type.name().contains("SEARCH_")) {
            toLog = toLog + TimeUtils.counterToDate(memoryVO.getThoughtTimeTicks()) + " ";
            toLog = toLog + (Object)((Object)memoryVO.getActualAtomicAction().type) + " started.\r\n";
            this.lastAtomicAction = memoryVO.getActualAtomicAction();
        }
        if (!toLog.equals("")) {
            try {
                this.outputFile.write(toLog.getBytes());
            }
            catch (IOException ex) {
                Logger.getLogger(DMSLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void writeAMessage(String message) {
        try {
            if (!this.ready) {
                return;
            }
            this.outputFile.write(message.getBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(DMSLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void cleanUp() {
        try {
            this.outputFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DMSLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void logToFile(String text) {
        this.writeAMessage(DateUtils.nowHours() + ":  " + text + "\r\n");
    }

    @Override
    public void logToFilePlainText(String text) {
        this.writeAMessage(text);
    }
}

