/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.SearchPocket;

class AtomicSearchPocket
extends AtomicAction {
    DecisionModuleImpl module;

    public AtomicSearchPocket(Action parent, DecisionModuleImpl module) {
        this.parent = parent;
        this.agent = module.agent;
        this.module = module;
        this.type = AtomicActions.SEARCH_POCKET;
        this.dModule = module;
    }

    @Override
    public void execute() {
        this.counter = this.agent.getCurrentTime();
    }

    @Override
    public boolean succeeded() {
        AffordanceType aff = ((SearchPocket)this.parent).affordance;
        EItem item = this.module.inventory.getItemOfAffordance(aff);
        if (item != null) {
            this.module.perceptiveField.satisfyAffordance(this.parent.intention.getAncestorAction(), aff, item);
            this.agent.getLog().info("Atomic search pocket - " + (Object)((Object)aff) + " - finished. Duration :" + this.counter + " rounds.");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return this.counter - this.actionStart > this.parent.timeLimit;
    }
}

