package launcher;

//import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
//import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Holds information used to set up one agent in the environment.
 * 
 * @author Knight
 */
@XmlRootElement
public class AgentEntry implements Serializable {

    @XmlElement
    /** XML file containing map info */
    public String mapFile = null;
    @XmlElement
    /** XML file containing transitions */
    public String planFile = null;
    @XmlElement
    /** class of the agent to spawn in the environment */
    public String className = null;
    @XmlElement
    /** after how many days the bot terminates */
    public int lifeTime = 0;


    public AgentEntry() {
    }

    public AgentEntry(String mapFile, String planFile, String className, int lifeTime) {
        this.mapFile = mapFile;
        this.planFile = planFile;
        this.className = className;
        this.lifeTime = lifeTime;
    }

    @Override
    public String toString() {
        String result = "mapDefinitionFile: " + this.mapFile;
        result += "planDefinitionFile: " + this.planFile;
        result += "className: " + this.className;
        result += "lifeTime: " + this.lifeTime;
        return result;
    }
}
