package atomicActions.basic;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import java.io.Serializable;
import utils.TimeUtils;

/**
 * Eat, eating as long as the time limit says
 * @author Ondrej
 */
public class Use extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            agent.getAct().act(new Configuration().setAction("NONE"));
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    protected String getEnvironmentAction() {
        return "USE";
    }

    @Override
    public void execute() {

        if (counter == 0) {
            agent.getLog().info("Useing");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public Use(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.USE;
    }
}
