package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;

/**
 * wash food, so it is just a virtual action, it has no direct impact on environment, it just has to be executed
 * can take some time...
 * @author Ondrej
 */
public class WashFood extends AtomicAction implements Serializable {

    int duration = 4;

    @Override
    public void execute() {

        if (counter == 0) {
            agent.getLog().info("wash food");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    @Override
    public boolean succeeded() {
        if (counter > duration) {
            logFinished("wash food finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    public WashFood(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.WASH_FOOD;
    }

}
