package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

/**
 * Seeing a movie, just say he is doing it
 * @author Ondrej
 */
public class Think extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Thinking finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Thinking.");
        }
        counter = agent.getCurrentTime();
    }

    public Think(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.THINK;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
    }
}