package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Bot is sitting (or rather standing) on the lecture
 * @author Ondrej
 */
public class SitAtTheLecture extends AtomicAction implements Serializable {
    
    private int lastMessageSent = 0;

    private int messageDelay = 20;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("End of sitting at the lecture - finaly! Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    public SitAtTheLecture() {
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Sitting at the lecture");
            initialisation();
        }
        counter = agent.getCurrentTime();
     /*   for (Player plr : agent.players.getVisiblePlayers().values()) {

            if (plr.getAction().toUpperCase().contains("SIT_AT_THE_LECTURE")) {
                this.agent.getAct().act(new TurnTo().setLocation(plr.getLocation()));

                if ((counter - lastMessageSent) > messageDelay) {
                    this.agent.getAct().act(new SendMessage().setText("*STUDY TOGETHER* Another boring lecture. Lets play tic tac toe.").setFadeOut(8));
                    lastMessageSent = counter;
                }
                break;
            }
        }*/
    }

    @Override
    protected String getEnvironmentAction() {
        return "USE";
    }

    public SitAtTheLecture (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SIT_AT_THE_LECTURE;
    }

}