package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;

/**
 * Shopping, just say he is doing it
 * @author Ondrej
 */
public class Shop extends AtomicAction implements Serializable {

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Shopping.");
            initialisation();
        }
        this.counter = agent.getCurrentTime();
    }

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Shopping finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        return false;
    }

    public Shop(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SHOP;
    }

}
